/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Objects;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.error.ShouldBeEqualWithinPercentage;
import org.assertj.core.error.ShouldNotBeEqualWithinOffset;
import org.assertj.core.error.ShouldNotBeEqualWithinPercentage;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparisonStrategy;

public abstract class Numbers<NUMBER extends Number>
extends Comparables {
    public Numbers() {
    }

    public Numbers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    protected abstract NUMBER zero();

    protected abstract NUMBER one();

    public void assertIsZero(AssertionInfo info2, NUMBER actual) {
        this.assertEqualByComparison(info2, (Comparable)actual, this.zero());
    }

    public void assertIsNotZero(AssertionInfo info2, NUMBER actual) {
        this.assertNotEqualByComparison(info2, (Comparable)actual, this.zero());
    }

    public void assertIsOne(AssertionInfo info2, NUMBER actual) {
        this.assertEqualByComparison(info2, (Comparable)actual, this.one());
    }

    public void assertIsNegative(AssertionInfo info2, NUMBER actual) {
        this.assertLessThan(info2, (Comparable)actual, this.zero());
    }

    public void assertIsPositive(AssertionInfo info2, NUMBER actual) {
        this.assertGreaterThan(info2, (Comparable)actual, this.zero());
    }

    public void assertIsNotNegative(AssertionInfo info2, NUMBER actual) {
        this.assertGreaterThanOrEqualTo(info2, (Comparable)actual, this.zero());
    }

    public void assertIsNotPositive(AssertionInfo info2, NUMBER actual) {
        this.assertLessThanOrEqualTo(info2, (Comparable)actual, this.zero());
    }

    public void assertIsBetween(AssertionInfo info2, NUMBER actual, NUMBER start, NUMBER end) {
        this.assertIsBetween(info2, (Comparable)actual, start, end, true, true);
    }

    public void assertIsStrictlyBetween(AssertionInfo info2, NUMBER actual, NUMBER start, NUMBER end) {
        this.assertIsBetween(info2, (Comparable)actual, start, end, false, false);
    }

    public void assertIsCloseTo(AssertionInfo info2, NUMBER actual, NUMBER expected, Offset<NUMBER> offset) {
        Numbers.assertNotNull(info2, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        if (this.areEqual(actual, expected)) {
            return;
        }
        if (!offset.strict && this.isGreaterThan(this.absDiff(actual, expected), offset.value)) {
            throw this.failures.failure(info2, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, this.absDiff(actual, expected)));
        }
        if (offset.strict && this.isGreaterThanOrEqualTo(this.absDiff(actual, expected), offset.value)) {
            throw this.failures.failure(info2, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, this.absDiff(actual, expected)));
        }
    }

    public void assertIsNotCloseTo(AssertionInfo info2, NUMBER actual, NUMBER expected, Offset<NUMBER> offset) {
        Numbers.assertNotNull(info2, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        NUMBER diff = this.absDiff(actual, expected);
        if (offset.strict && this.isGreaterThanOrEqualTo(diff, offset.value)) {
            return;
        }
        if (!offset.strict && !this.areEqual(actual, expected) && this.isGreaterThan(diff, offset.value)) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeEqualWithinOffset.shouldNotBeEqual(actual, expected, offset, diff));
    }

    public void assertIsCloseToPercentage(AssertionInfo info2, NUMBER actual, NUMBER other, Percentage percentage) {
        Numbers.assertNotNull(info2, actual);
        CommonValidations.checkPercentageIsNotNull(percentage);
        CommonValidations.checkNumberIsNotNull(other);
        if (this.areEqual(actual, other)) {
            return;
        }
        double acceptableDiff = Math.abs(percentage.value * ((Number)other).doubleValue() / 100.0);
        double actualDiff = ((Number)this.absDiff(actual, other)).doubleValue();
        if (actualDiff > acceptableDiff || Double.isNaN(actualDiff) || Double.isInfinite(actualDiff)) {
            throw this.failures.failure(info2, ShouldBeEqualWithinPercentage.shouldBeEqualWithinPercentage(actual, other, percentage, this.absDiff(actual, other)));
        }
    }

    public void assertIsNotCloseToPercentage(AssertionInfo info2, NUMBER actual, NUMBER other, Percentage percentage) {
        Numbers.assertNotNull(info2, actual);
        CommonValidations.checkPercentageIsNotNull(percentage);
        CommonValidations.checkNumberIsNotNull(other);
        double diff = Math.abs(percentage.value * ((Number)other).doubleValue() / 100.0);
        boolean areEqual = this.areEqual(actual, other);
        if (!areEqual && Double.isInfinite(diff)) {
            return;
        }
        if (((Number)this.absDiff(actual, other)).doubleValue() <= diff || areEqual) {
            throw this.failures.failure(info2, ShouldNotBeEqualWithinPercentage.shouldNotBeEqualWithinPercentage(actual, other, percentage, this.absDiff(actual, other)));
        }
    }

    protected abstract NUMBER absDiff(NUMBER var1, NUMBER var2);

    protected abstract boolean isGreaterThan(NUMBER var1, NUMBER var2);

    protected boolean isGreaterThanOrEqualTo(NUMBER value, NUMBER other) {
        return this.areEqual(value, other) || this.isGreaterThan(value, other);
    }

    protected boolean areEqual(NUMBER value, NUMBER other) {
        return Objects.equals(value, other);
    }
}

