/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class BinaryRepresentation
extends StandardRepresentation {
    public static final BinaryRepresentation BINARY_REPRESENTATION = new BinaryRepresentation();
    public static final String BYTE_PREFIX = "0b";

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        if (object instanceof Number) {
            return this.toStringOf((Number)object);
        }
        if (object instanceof String) {
            return this.toStringOf(this, (String)object);
        }
        return super.toStringOf(object);
    }

    protected String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            return this.toStringOf((Byte)number);
        }
        if (number instanceof Short) {
            return this.toStringOf((Short)number);
        }
        if (number instanceof Integer) {
            return this.toStringOf((Integer)number);
        }
        if (number instanceof Long) {
            return this.toStringOf((Long)number);
        }
        if (number instanceof Float) {
            return this.toStringOf((Float)number);
        }
        if (number instanceof Double) {
            return this.toStringOf((Double)number);
        }
        return number == null ? null : number.toString();
    }

    protected String toStringOf(Byte b) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(b & 0xFF), 8);
    }

    protected String toStringOf(Short s) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(s & 0xFFFF), 16);
    }

    protected String toStringOf(Integer i2) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(i2), 32);
    }

    @Override
    protected String toStringOf(Long l) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(l), 64);
    }

    @Override
    protected String toStringOf(Float f) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(Float.floatToIntBits(f.floatValue())), 32);
    }

    protected String toStringOf(Double d) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(Double.doubleToRawLongBits(d)), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    private static String toGroupedBinary(String value, int size) {
        return BYTE_PREFIX + NumberGrouping.toBinaryLiteral(BinaryRepresentation.toBinary(value, size));
    }

    private static String toBinary(String value, int size) {
        return String.format("%" + size + "s", value).replace(' ', '0');
    }
}

