/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert.comparator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONCompareUtil {
    private static Integer INTEGER_ONE = new Integer(1);

    private JSONCompareUtil() {
    }

    public static Map<Object, JSONObject> arrayOfJsonObjectToMap(JSONArray array, String uniqueKey) throws JSONException {
        HashMap<Object, JSONObject> valueMap = new HashMap<Object, JSONObject>();
        for (int i2 = 0; i2 < array.length(); ++i2) {
            JSONObject jsonObject = (JSONObject)array.get(i2);
            Object id = jsonObject.get(uniqueKey);
            valueMap.put(id, jsonObject);
        }
        return valueMap;
    }

    public static String findUniqueKey(JSONArray expected) throws JSONException {
        JSONObject o = (JSONObject)expected.get(0);
        for (String candidate : JSONCompareUtil.getKeys(o)) {
            if (!JSONCompareUtil.isUsableAsUniqueKey(candidate, expected)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUsableAsUniqueKey(String candidate, JSONArray array) throws JSONException {
        HashSet<Object> seenValues = new HashSet<Object>();
        for (int i2 = 0; i2 < array.length(); ++i2) {
            Object item = array.get(i2);
            if (!(item instanceof JSONObject)) return false;
            JSONObject o = (JSONObject)item;
            if (!o.has(candidate)) return false;
            Object value = o.get(candidate);
            if (!JSONCompareUtil.isSimpleValue(value) || seenValues.contains(value)) {
                return false;
            }
            seenValues.add(value);
        }
        return true;
    }

    public static List<Object> jsonArrayToList(JSONArray expected) throws JSONException {
        ArrayList<Object> jsonObjects = new ArrayList<Object>(expected.length());
        for (int i2 = 0; i2 < expected.length(); ++i2) {
            jsonObjects.add(JSONCompareUtil.getObjectOrNull(expected, i2));
        }
        return jsonObjects;
    }

    public static Object getObjectOrNull(JSONArray jsonArray, int index) throws JSONException {
        return jsonArray.isNull(index) ? null : jsonArray.get(index);
    }

    public static boolean allSimpleValues(JSONArray array) throws JSONException {
        for (int i2 = 0; i2 < array.length(); ++i2) {
            if (array.isNull(i2) || JSONCompareUtil.isSimpleValue(array.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimpleValue(Object o) {
        return !(o instanceof JSONObject) && !(o instanceof JSONArray);
    }

    public static boolean allJSONObjects(JSONArray array) throws JSONException {
        for (int i2 = 0; i2 < array.length(); ++i2) {
            if (array.get(i2) instanceof JSONObject) continue;
            return false;
        }
        return true;
    }

    public static boolean allJSONArrays(JSONArray array) throws JSONException {
        for (int i2 = 0; i2 < array.length(); ++i2) {
            if (array.get(i2) instanceof JSONArray) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getKeys(JSONObject jsonObject) {
        TreeSet<String> keys = new TreeSet<String>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            keys.add((String)iter.next());
        }
        return keys;
    }

    public static String qualify(String prefix, String key) {
        return "".equals(prefix) ? key : prefix + "." + key;
    }

    public static String formatUniqueKey(String key, String uniqueKey, Object value) {
        return key + "[" + uniqueKey + "=" + value + "]";
    }

    public static <T> Map<T, Integer> getCardinalityMap(Collection<T> coll) {
        HashMap<T, Integer> count = new HashMap<T, Integer>();
        for (T item : coll) {
            Integer c = (Integer)count.get(item);
            if (c == null) {
                count.put(item, INTEGER_ONE);
                continue;
            }
            count.put(item, new Integer(c + 1));
        }
        return count;
    }
}

