/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.SQLDialect;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class JooqExceptionTranslator
implements ExecuteListener {
    private static final Log logger = LogFactory.getLog(JooqExceptionTranslator.class);

    public void exception(ExecuteContext context) {
        SQLExceptionTranslator translator = this.getTranslator(context);
        for (SQLException exception = context.sqlException(); exception != null; exception = exception.getNextException()) {
            this.handle(context, translator, exception);
        }
    }

    private SQLExceptionTranslator getTranslator(ExecuteContext context) {
        String dbName;
        SQLDialect dialect = context.configuration().dialect();
        if (dialect != null && dialect.thirdParty() != null && (dbName = dialect.thirdParty().springDbName()) != null) {
            return new SQLErrorCodeSQLExceptionTranslator(dbName);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    private void handle(ExecuteContext context, SQLExceptionTranslator translator, SQLException exception) {
        DataAccessException translated = this.translate(context, translator, exception);
        if (exception.getNextException() == null) {
            if (translated != null) {
                context.exception((RuntimeException)translated);
            }
        } else {
            logger.error("Execution of SQL statement failed.", translated != null ? translated : exception);
        }
    }

    private DataAccessException translate(ExecuteContext context, SQLExceptionTranslator translator, SQLException exception) {
        return translator.translate("jOOQ", context.sql(), exception);
    }
}

