/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcAutoConfiguration;
import org.springframework.boot.test.web.htmlunit.webdriver.LocalHostWebConnectionHtmlUnitDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.webdriver.MockMvcHtmlUnitDriverBuilder;
import org.springframework.util.ClassUtils;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={HtmlUnitDriver.class})
@ConditionalOnProperty(prefix="spring.test.mockmvc.webdriver", name={"enabled"}, matchIfMissing=true)
public class MockMvcWebDriverAutoConfiguration {
    private static final String SECURITY_CONTEXT_EXECUTOR = "org.springframework.security.concurrent.DelegatingSecurityContextExecutor";

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class, MockMvcHtmlUnitDriverBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    public MockMvcHtmlUnitDriverBuilder mockMvcHtmlUnitDriverBuilder(MockMvc mockMvc, Environment environment2) {
        return MockMvcHtmlUnitDriverBuilder.mockMvcSetup(mockMvc).withDelegate(new LocalHostWebConnectionHtmlUnitDriver(environment2, BrowserVersion.CHROME));
    }

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class})
    @ConditionalOnBean(value={MockMvcHtmlUnitDriverBuilder.class})
    public HtmlUnitDriver htmlUnitDriver(MockMvcHtmlUnitDriverBuilder builder) {
        HtmlUnitDriver driver = builder.build();
        if (ClassUtils.isPresent(SECURITY_CONTEXT_EXECUTOR, this.getClass().getClassLoader())) {
            driver.setExecutor((Executor)new DelegatingSecurityContextExecutor(Executors.newSingleThreadExecutor()));
        }
        return driver;
    }
}

