/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class WebDriverScope
implements Scope {
    public static final String NAME = "webDriver";
    private static final String WEB_DRIVER_CLASS = "org.openqa.selenium.WebDriver";
    private static final String[] BEAN_CLASSES = new String[]{"org.openqa.selenium.WebDriver", "org.springframework.test.web.servlet.htmlunit.webdriver.MockMvcHtmlUnitDriverBuilder"};
    private final Map<String, Object> instances = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            Object instance = this.instances.get(name);
            if (instance == null) {
                instance = objectFactory.getObject();
                this.instances.put(name, instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(String name) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            return this.instances.remove(name);
        }
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
    }

    @Override
    public Object resolveContextualObject(String key) {
        return null;
    }

    @Override
    public String getConversationId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reset() {
        boolean reset2 = false;
        Map<String, Object> map = this.instances;
        synchronized (map) {
            for (Object instance : this.instances.values()) {
                reset2 = true;
                if (!(instance instanceof WebDriver)) continue;
                WebDriver webDriver = (WebDriver)instance;
                webDriver.quit();
            }
            this.instances.clear();
        }
        return reset2;
    }

    static void registerWith(ConfigurableApplicationContext context) {
        if (!ClassUtils.isPresent(WEB_DRIVER_CLASS, null)) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory.getRegisteredScope(NAME) == null) {
            beanFactory.registerScope(NAME, new WebDriverScope());
        }
        context.addBeanFactoryPostProcessor(WebDriverScope::postProcessBeanFactory);
    }

    private static void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanClass : BEAN_CLASSES) {
            for (String beanName : beanFactory.getBeanNamesForType(ClassUtils.resolveClassName(beanClass, null))) {
                BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
                if (StringUtils.hasLength(definition.getScope())) continue;
                definition.setScope(NAME);
            }
        }
    }

    static WebDriverScope getFrom(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            WebDriverScope webDriverScope;
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
            Scope scope = configurableContext.getBeanFactory().getRegisteredScope(NAME);
            return scope instanceof WebDriverScope ? (webDriverScope = (WebDriverScope)scope) : null;
        }
        return null;
    }
}

