/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.assertj.core.api.AssertProvider;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.AssertProviderApplicationContextInvocationHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public interface ApplicationContextAssertProvider<C extends ApplicationContext>
extends ApplicationContext,
AssertProvider<ApplicationContextAssert<C>>,
Closeable {
    @Override
    @Deprecated(since="2.0.0", forRemoval=false)
    public ApplicationContextAssert<C> assertThat();

    public C getSourceApplicationContext();

    public <T extends C> T getSourceApplicationContext(Class<T> var1);

    public Throwable getStartupFailure();

    @Override
    public void close();

    public static <T extends ApplicationContextAssertProvider<C>, C extends ApplicationContext> T get(Class<T> type, Class<? extends C> contextType, Supplier<? extends C> contextSupplier) {
        Assert.notNull(type, "Type must not be null");
        Assert.isTrue(type.isInterface(), "Type must be an interface");
        Assert.notNull(contextType, "ContextType must not be null");
        Assert.isTrue(contextType.isInterface(), "ContextType must be an interface");
        Class[] interfaces = new Class[]{type, contextType};
        return (T)((ApplicationContextAssertProvider)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new AssertProviderApplicationContextInvocationHandler(contextType, contextSupplier)));
    }
}

