/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import java.util.HashSet;
import org.mockito.Mockito;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.NativeDetector;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class ResetMocksTestExecutionListener
extends AbstractTestExecutionListener {
    private static final boolean MOCKITO_IS_PRESENT = ClassUtils.isPresent("org.mockito.MockSettings", ResetMocksTestExecutionListener.class.getClassLoader());

    @Override
    public int getOrder() {
        return 2147483547;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (MOCKITO_IS_PRESENT && !NativeDetector.inNativeImage()) {
            this.resetMocks(testContext.getApplicationContext(), MockReset.BEFORE);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (MOCKITO_IS_PRESENT && !NativeDetector.inNativeImage()) {
            this.resetMocks(testContext.getApplicationContext(), MockReset.AFTER);
        }
    }

    private void resetMocks(ApplicationContext applicationContext, MockReset reset2) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            this.resetMocks(configurableContext, reset2);
        }
    }

    private void resetMocks(ConfigurableApplicationContext applicationContext, MockReset reset2) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        String[] names = beanFactory.getBeanDefinitionNames();
        HashSet<String> instantiatedSingletons = new HashSet<String>(Arrays.asList(beanFactory.getSingletonNames()));
        for (String name : names) {
            Object bean2;
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (!definition.isSingleton() || !instantiatedSingletons.contains(name) || !reset2.equals((Object)MockReset.get(bean2 = beanFactory.getSingleton(name)))) continue;
            Mockito.reset(bean2);
        }
        try {
            MockitoBeans mockedBeans = beanFactory.getBean(MockitoBeans.class);
            for (Object mockedBean : mockedBeans) {
                if (!reset2.equals((Object)MockReset.get(mockedBean))) continue;
                Mockito.reset(mockedBean);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (applicationContext.getParent() != null) {
            this.resetMocks(applicationContext.getParent(), reset2);
        }
    }
}

