/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.client.BasicAuthentication;
import org.springframework.boot.web.client.RestTemplateRequestCustomizer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestInitializer;

class RestTemplateBuilderClientHttpRequestInitializer
implements ClientHttpRequestInitializer {
    private final BasicAuthentication basicAuthentication;
    private final Map<String, List<String>> defaultHeaders;
    private final Set<RestTemplateRequestCustomizer<?>> requestCustomizers;

    RestTemplateBuilderClientHttpRequestInitializer(BasicAuthentication basicAuthentication, Map<String, List<String>> defaultHeaders, Set<RestTemplateRequestCustomizer<?>> requestCustomizers) {
        this.basicAuthentication = basicAuthentication;
        this.defaultHeaders = defaultHeaders;
        this.requestCustomizers = requestCustomizers;
    }

    @Override
    public void initialize(ClientHttpRequest request2) {
        HttpHeaders headers = request2.getHeaders();
        if (this.basicAuthentication != null) {
            this.basicAuthentication.applyTo(headers);
        }
        this.defaultHeaders.forEach(headers::putIfAbsent);
        LambdaSafe.callbacks(RestTemplateRequestCustomizer.class, this.requestCustomizers, request2, new Object[0]).invoke(customizer2 -> customizer2.customize(request2));
    }
}

