/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;

public class TomcatEmbeddedWebappClassLoader
extends ParallelWebappClassLoader {
    private static final Log logger = LogFactory.getLog(TomcatEmbeddedWebappClassLoader.class);

    public TomcatEmbeddedWebappClassLoader() {
    }

    public TomcatEmbeddedWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public URL findResource(String name) {
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Collections.emptyEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        TomcatEmbeddedWebappClassLoader tomcatEmbeddedWebappClassLoader = JreCompat.isGraalAvailable() ? this : this.getClassLoadingLock(name);
        synchronized (tomcatEmbeddedWebappClassLoader) {
            Class<?> result = this.findExistingLoadedClass(name);
            Class<?> clazz = result = result != null ? result : this.doLoadClass(name);
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
            return this.resolveIfNecessary(result, resolve);
        }
    }

    private Class<?> findExistingLoadedClass(String name) {
        Class<?> resultClass = this.findLoadedClass0(name);
        resultClass = resultClass != null || JreCompat.isGraalAvailable() ? resultClass : this.findLoadedClass(name);
        return resultClass;
    }

    private Class<?> doLoadClass(String name) {
        if (this.delegate || this.filter(name, true)) {
            Class<?> result = this.loadFromParent(name);
            return result != null ? result : this.findClassIgnoringNotFound(name);
        }
        Class<?> result = this.findClassIgnoringNotFound(name);
        return result != null ? result : this.loadFromParent(name);
    }

    private Class<?> resolveIfNecessary(Class<?> resultClass, boolean resolve) {
        if (resolve) {
            this.resolveClass(resultClass);
        }
        return resultClass;
    }

    @Override
    protected void addURL(URL url) {
        if (logger.isTraceEnabled()) {
            logger.trace("Ignoring request to add " + url + " to the tomcat classloader");
        }
    }

    private Class<?> loadFromParent(String name) {
        if (this.parent == null) {
            return null;
        }
        try {
            return Class.forName(name, false, this.parent);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private Class<?> findClassIgnoringNotFound(String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        if (!JreCompat.isGraalAvailable()) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

