/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpelPropertyComparator<T>
implements Comparator<T> {
    private final String path;
    private final SpelExpressionParser parser;
    private boolean asc = true;
    private boolean nullsFirst = true;
    @Nullable
    private SpelExpression expression;

    public SpelPropertyComparator(String path, SpelExpressionParser parser) {
        Assert.hasText(path, "Path must not be null or empty");
        Assert.notNull((Object)parser, "SpelExpressionParser must not be null");
        this.path = path;
        this.parser = parser;
    }

    public SpelPropertyComparator<T> asc() {
        this.asc = true;
        return this;
    }

    public SpelPropertyComparator<T> desc() {
        this.asc = false;
        return this;
    }

    public SpelPropertyComparator<T> nullsFirst() {
        this.nullsFirst = true;
        return this;
    }

    public SpelPropertyComparator<T> nullsLast() {
        this.nullsFirst = false;
        return this;
    }

    protected SpelExpression getExpression() {
        if (this.expression == null) {
            this.expression = this.parser.parseRaw(this.buildExpressionForPath());
        }
        return this.expression;
    }

    protected String buildExpressionForPath() {
        String rawExpression = String.format("new org.springframework.util.comparator.NullSafeComparator(new org.springframework.util.comparator.ComparableComparator(), %s).compare(#arg1?.%s,#arg2?.%s)", Boolean.toString(this.nullsFirst), this.path.replace(".", "?."), this.path.replace(".", "?."));
        return rawExpression;
    }

    @Override
    public int compare(T arg1, T arg2) {
        SpelExpression expressionToUse = this.getExpression();
        expressionToUse.getEvaluationContext().setVariable("arg1", arg1);
        expressionToUse.getEvaluationContext().setVariable("arg2", arg2);
        return expressionToUse.getValue(Integer.class) * (this.asc ? 1 : -1);
    }

    public String getPath() {
        return this.path;
    }
}

