/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;
    private final boolean allowInFlightCacheCreation;

    private RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation) {
        Assert.notNull((Object)cacheWriter, "CacheWriter must not be null");
        Assert.notNull((Object)defaultCacheConfiguration, "DefaultCacheConfiguration must not be null");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
        this.allowInFlightCacheCreation = allowInFlightCacheCreation;
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        this(cacheWriter, defaultCacheConfiguration, true);
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, true, initialCacheNames);
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        for (String cacheName : initialCacheNames) {
            this.initialCacheConfiguration.put(cacheName, defaultCacheConfiguration);
        }
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, true);
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        Assert.notNull(initialCacheConfigurations, "InitialCacheConfigurations must not be null");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    public static RedisCacheManager create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        return new RedisCacheManager(RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory), RedisCacheConfiguration.defaultCacheConfig());
    }

    public static RedisCacheManagerBuilder builder() {
        return new RedisCacheManagerBuilder();
    }

    public static RedisCacheManagerBuilder builder(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        return RedisCacheManagerBuilder.fromConnectionFactory(connectionFactory);
    }

    public static RedisCacheManagerBuilder builder(RedisCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, "CacheWriter must not be null");
        return RedisCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    protected Collection<RedisCache> loadCaches() {
        LinkedList<RedisCache> caches = new LinkedList<RedisCache>();
        for (Map.Entry<String, RedisCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createRedisCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    @Override
    protected RedisCache getMissingCache(String name) {
        return this.allowInFlightCacheCreation ? this.createRedisCache(name, this.defaultCacheConfig) : null;
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        HashMap configurationMap = new HashMap(this.getCacheNames().size());
        this.getCacheNames().forEach(it -> {
            RedisCache cache = (RedisCache)RedisCache.class.cast(this.lookupCache((String)it));
            configurationMap.put(it, cache != null ? cache.getCacheConfiguration() : null);
        });
        return Collections.unmodifiableMap(configurationMap);
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new RedisCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public static class RedisCacheManagerBuilder {
        @Nullable
        private RedisCacheWriter cacheWriter;
        private CacheStatisticsCollector statisticsCollector = CacheStatisticsCollector.none();
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        private final Map<String, RedisCacheConfiguration> initialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private boolean enableTransactions;
        boolean allowInFlightCacheCreation = true;

        private RedisCacheManagerBuilder() {
        }

        private RedisCacheManagerBuilder(RedisCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static RedisCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
            return new RedisCacheManagerBuilder(RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory));
        }

        public static RedisCacheManagerBuilder fromCacheWriter(RedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, "CacheWriter must not be null");
            return new RedisCacheManagerBuilder(cacheWriter);
        }

        public RedisCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, "DefaultCacheConfiguration must not be null");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public RedisCacheManagerBuilder cacheWriter(RedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, "CacheWriter must not be null");
            this.cacheWriter = cacheWriter;
            return this;
        }

        public RedisCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public RedisCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, "CacheNames must not be null");
            cacheNames.forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public RedisCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, "CacheConfigurations must not be null");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull(configuration, String.format("RedisCacheConfiguration for cache %s must not be null", cacheName)));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public RedisCacheManagerBuilder withCacheConfiguration(String cacheName, RedisCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, "CacheName must not be null");
            Assert.notNull((Object)cacheConfiguration, "CacheConfiguration must not be null");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public RedisCacheManagerBuilder disableCreateOnMissingCache() {
            this.allowInFlightCacheCreation = false;
            return this;
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public Optional<RedisCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public RedisCacheManagerBuilder enableStatistics() {
            this.statisticsCollector = CacheStatisticsCollector.create();
            return this;
        }

        public RedisCacheManager build() {
            Assert.state(this.cacheWriter != null, "CacheWriter must not be null You can provide one via 'RedisCacheManagerBuilder#cacheWriter(RedisCacheWriter)'");
            RedisCacheWriter theCacheWriter = this.cacheWriter;
            if (!this.statisticsCollector.equals(CacheStatisticsCollector.none())) {
                theCacheWriter = this.cacheWriter.withStatisticsCollector(this.statisticsCollector);
            }
            RedisCacheManager cm = new RedisCacheManager(theCacheWriter, this.defaultCacheConfiguration, this.initialCaches, this.allowInFlightCacheCreation);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

