/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractRedisConnection
implements RedisConnection {
    private final Log LOGGER = LogFactory.getLog(this.getClass());
    @Nullable
    private RedisSentinelConfiguration sentinelConfiguration;
    private final Map<RedisNode, RedisSentinelConnection> connectionCache = new ConcurrentHashMap<RedisNode, RedisSentinelConnection>();

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        if (!this.hasRedisSentinelConfigured()) {
            throw new InvalidDataAccessResourceUsageException("No sentinels configured.");
        }
        RedisNode node = this.selectActiveSentinel();
        RedisSentinelConnection connection = this.connectionCache.get(node);
        if (connection == null || !connection.isOpen()) {
            connection = this.getSentinelConnection(node);
            this.connectionCache.putIfAbsent(node, connection);
        }
        return connection;
    }

    public void setSentinelConfiguration(RedisSentinelConfiguration sentinelConfiguration) {
        this.sentinelConfiguration = sentinelConfiguration;
    }

    public boolean hasRedisSentinelConfigured() {
        return this.sentinelConfiguration != null;
    }

    private RedisNode selectActiveSentinel() {
        Assert.state(this.hasRedisSentinelConfigured(), "Sentinel configuration missing");
        for (RedisNode node : this.sentinelConfiguration.getSentinels()) {
            if (!this.isActive(node)) continue;
            return node;
        }
        throw new InvalidDataAccessApiUsageException("Could not find any active sentinels");
    }

    protected boolean isActive(RedisNode node) {
        return false;
    }

    protected RedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        throw new UnsupportedOperationException("Sentinel is not supported by this client.");
    }

    @Override
    public void close() throws DataAccessException {
        if (this.connectionCache.isEmpty()) {
            return;
        }
        for (RedisNode node : this.connectionCache.keySet()) {
            RedisSentinelConnection connection = this.connectionCache.remove(node);
            if (!connection.isOpen()) continue;
            try {
                connection.close();
            }
            catch (IOException e) {
                this.LOGGER.info("Failed to close sentinel connection", e);
            }
        }
    }
}

