/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Set;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterCommandsProvider;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisClusterConnection
extends RedisConnection,
DefaultedRedisClusterConnection,
RedisClusterCommandsProvider {
    @Nullable
    public String ping(RedisClusterNode var1);

    @Nullable
    public Set<byte[]> keys(RedisClusterNode var1, byte[] var2);

    public Cursor<byte[]> scan(RedisClusterNode var1, ScanOptions var2);

    @Nullable
    public byte[] randomKey(RedisClusterNode var1);

    @Nullable
    default public <T> T execute(String command, byte[] key, Collection<byte[]> args) {
        Assert.notNull((Object)command, "Command must not be null");
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(args, "Args must not be null");
        byte[][] commandArgs = new byte[args.size() + 1][];
        commandArgs[0] = key;
        int targetIndex = 1;
        for (byte[] binaryArgument : args) {
            commandArgs[targetIndex++] = binaryArgument;
        }
        return (T)this.execute(command, commandArgs);
    }
}

