/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.StringPipelineBinaryCommands;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.SetParams;

class JedisStringCommands
implements RedisStringCommands {
    private final JedisConnection connection;

    JedisStringCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::get, StringPipelineBinaryCommands::get, key);
    }

    @Override
    @Nullable
    public byte[] getDel(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::getDel, StringPipelineBinaryCommands::getDel, key);
    }

    @Override
    @Nullable
    public byte[] getEx(byte[] key, Expiration expiration) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)expiration, "Expiration must not be null");
        return this.connection.invoke().just(Jedis::getEx, StringPipelineBinaryCommands::getEx, key, JedisConverters.toGetExParams(expiration));
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::getSet, StringPipelineBinaryCommands::getSet, key, value);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::mget, StringPipelineBinaryCommands::mget, keys);
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().from(Jedis::set, StringPipelineBinaryCommands::set, key, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        Assert.notNull((Object)expiration, "Expiration must not be null");
        Assert.notNull((Object)option, "Option must not be null");
        SetParams params = JedisConverters.toSetCommandExPxArgument(expiration, JedisConverters.toSetCommandNxXxArgument(option));
        return this.connection.invoke().from(Jedis::set, StringPipelineBinaryCommands::set, key, value, params).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().from(Jedis::setnx, StringPipelineBinaryCommands::setnx, key, value).get(Converters.longToBoolean());
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Time must be less than Integer.MAX_VALUE for setEx in Jedis");
        }
        return this.connection.invoke().from(Jedis::setex, StringPipelineBinaryCommands::setex, key, seconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().from(Jedis::psetex, StringPipelineBinaryCommands::psetex, key, milliseconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null");
        return this.connection.invoke().from(Jedis::mset, StringPipelineBinaryCommands::mset, JedisConverters.toByteArrays(tuples)).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, "Tuples must not be null");
        return this.connection.invoke().from(Jedis::msetnx, StringPipelineBinaryCommands::msetnx, JedisConverters.toByteArrays(tuples)).get(Converters.longToBoolean());
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::incr, StringPipelineBinaryCommands::incr, key);
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::incrBy, StringPipelineBinaryCommands::incrBy, key, value);
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::incrByFloat, StringPipelineBinaryCommands::incrByFloat, key, value);
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::decr, StringPipelineBinaryCommands::decr, key);
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::decrBy, StringPipelineBinaryCommands::decrBy, key, value);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::append, StringPipelineBinaryCommands::append, key, value);
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::getrange, StringPipelineBinaryCommands::getrange, key, start, end);
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        this.connection.invokeStatus().just(Jedis::setrange, StringPipelineBinaryCommands::setrange, key, offset, value);
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::getbit, StringPipelineBinaryCommands::getbit, key, offset);
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::setbit, StringPipelineBinaryCommands::setbit, key, offset, value);
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::bitcount, StringPipelineBinaryCommands::bitcount, key);
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::bitcount, StringPipelineBinaryCommands::bitcount, key, start, end);
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)subCommands, "Command must not be null");
        return this.connection.invoke().just(Jedis::bitfield, StringPipelineBinaryCommands::bitfield, key, JedisConverters.toBitfieldCommandArguments(subCommands));
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)op, "BitOperation must not be null");
        Assert.notNull((Object)destination, "Destination key must not be null");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new IllegalArgumentException("Bitop NOT should only be performed against one key");
        }
        return this.connection.invoke().just(Jedis::bitop, StringPipelineBinaryCommands::bitop, JedisConverters.toBitOp(op), destination, keys);
    }

    @Override
    @Nullable
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull(range, "Range must not be null Use Range.unbounded() instead");
        if (range.getLowerBound().isBounded()) {
            BitPosParams params = range.getUpperBound().isBounded() ? new BitPosParams(range.getLowerBound().getValue().get().longValue(), range.getUpperBound().getValue().get().longValue()) : new BitPosParams(range.getLowerBound().getValue().get().longValue());
            return this.connection.invoke().just(Jedis::bitpos, StringPipelineBinaryCommands::bitpos, key, bit, params);
        }
        return this.connection.invoke().just(Jedis::bitpos, StringPipelineBinaryCommands::bitpos, key, bit);
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::strlen, StringPipelineBinaryCommands::strlen, key);
    }
}

