/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.pubsub.RedisPubSubListener;
import java.nio.ByteBuffer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceByteBufferPubSubListenerWrapper
implements RedisPubSubListener<ByteBuffer, ByteBuffer> {
    private final RedisPubSubListener<byte[], byte[]> delegate;

    LettuceByteBufferPubSubListenerWrapper(RedisPubSubListener<byte[], byte[]> delegate) {
        Assert.notNull(delegate, "RedisPubSubListener must not be null");
        this.delegate = delegate;
    }

    @Override
    public void message(ByteBuffer channel, ByteBuffer message) {
        this.delegate.message(LettuceByteBufferPubSubListenerWrapper.getBytes(channel), LettuceByteBufferPubSubListenerWrapper.getBytes(message));
    }

    @Override
    public void message(ByteBuffer pattern, ByteBuffer channel, ByteBuffer message) {
        this.delegate.message(LettuceByteBufferPubSubListenerWrapper.getBytes(channel), LettuceByteBufferPubSubListenerWrapper.getBytes(message), LettuceByteBufferPubSubListenerWrapper.getBytes(pattern));
    }

    @Override
    public void subscribed(ByteBuffer channel, long count) {
        this.delegate.subscribed(LettuceByteBufferPubSubListenerWrapper.getBytes(channel), count);
    }

    @Override
    public void psubscribed(ByteBuffer pattern, long count) {
        this.delegate.psubscribed(LettuceByteBufferPubSubListenerWrapper.getBytes(pattern), count);
    }

    @Override
    public void unsubscribed(ByteBuffer channel, long count) {
        this.delegate.unsubscribed(LettuceByteBufferPubSubListenerWrapper.getBytes(channel), count);
    }

    @Override
    public void punsubscribed(ByteBuffer pattern, long count) {
        this.delegate.punsubscribed(LettuceByteBufferPubSubListenerWrapper.getBytes(pattern), count);
    }

    private static byte[] getBytes(@Nullable ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return new byte[0];
        }
        return ByteUtils.getBytes(byteBuffer);
    }
}

