/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanStream;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveSetCommands
implements ReactiveSetCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SAddCommand, Long>> sAdd(Publisher<ReactiveSetCommands.SAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValues(), "Values must not be null");
            return cmd.sadd(command.getKey(), command.getValues().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SAddCommand, Long>((ReactiveSetCommands.SAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SRemCommand, Long>> sRem(Publisher<ReactiveSetCommands.SRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValues(), "Values must not be null");
            return cmd.srem(command.getKey(), command.getValues().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SRemCommand, Long>((ReactiveSetCommands.SRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> sPop(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.spop(command.getKey()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ByteBuffer> sPop(ReactiveSetCommands.SPopCommand command) {
        Assert.notNull((Object)command, "Command must not be null");
        Assert.notNull((Object)command.getKey(), "Key must not be null");
        return this.connection.execute(cmd -> cmd.spop(command.getKey(), command.getCount()));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>> sMove(Publisher<ReactiveSetCommands.SMoveCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            return cmd.smove(command.getKey(), command.getDestination(), command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>((ReactiveSetCommands.SMoveCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> sCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.scard(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SIsMemberCommand>> sIsMember(Publisher<ReactiveSetCommands.SIsMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            return cmd.sismember(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SIsMemberCommand>((ReactiveSetCommands.SIsMemberCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SMIsMemberCommand, Boolean>> sMIsMember(Publisher<ReactiveSetCommands.SMIsMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValues(), "Values must not be null");
            return cmd.smismember(command.getKey(), command.getValues().toArray(new ByteBuffer[0])).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SMIsMemberCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SInterCommand, Flux<ByteBuffer>>> sInter(Publisher<ReactiveSetCommands.SInterCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Flux result = cmd.sinter(command.getKeys().toArray(new ByteBuffer[0]));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SInterCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>> sInterStore(Publisher<ReactiveSetCommands.SInterStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            return cmd.sinterstore(command.getKey(), command.getKeys().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>((ReactiveSetCommands.SInterStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SUnionCommand, Flux<ByteBuffer>>> sUnion(Publisher<ReactiveSetCommands.SUnionCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Flux result = cmd.sunion(command.getKeys().toArray(new ByteBuffer[0]));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SUnionCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>> sUnionStore(Publisher<ReactiveSetCommands.SUnionStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            return cmd.sunionstore(command.getKey(), command.getKeys().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>((ReactiveSetCommands.SUnionStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SDiffCommand, Flux<ByteBuffer>>> sDiff(Publisher<ReactiveSetCommands.SDiffCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Flux result = cmd.sdiff(command.getKeys().toArray(new ByteBuffer[0]));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SDiffCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>> sDiffStore(Publisher<ReactiveSetCommands.SDiffStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            return cmd.sdiffstore(command.getKey(), command.getKeys().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>((ReactiveSetCommands.SDiffStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> sMembers(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Flux result = cmd.smembers(command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveRedisConnection.KeyCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> sScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getOptions(), "ScanOptions must not be null");
            Flux result = ScanStream.sscan(cmd, command.getKey(), LettuceConverters.toScanArgs(command.getOptions()));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveRedisConnection.KeyScanCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SRandMembersCommand, Flux<ByteBuffer>>> sRandMember(Publisher<ReactiveSetCommands.SRandMembersCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            boolean singleElement = !command.getCount().isPresent() || command.getCount().get().equals(1L);
            Mono result = singleElement ? cmd.srandmember(command.getKey()) : cmd.srandmember(command.getKey(), command.getCount().get());
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SRandMembersCommand)command, Flux.from(result)));
        }));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

