/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.ScanStream;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.Value;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveZSetCommands
implements ReactiveZSetCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveZSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notEmpty(command.getTuples(), "Tuples must not be empty or null");
            ZAddArgs args = null;
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isIncr()) {
                    if (command.getTuples().size() > 1) {
                        throw new IllegalArgumentException("ZADD INCR must not contain more than one tuple");
                    }
                    Tuple tuple2 = command.getTuples().iterator().next();
                    return cmd.zaddincr(command.getKey(), tuple2.getScore(), ByteBuffer.wrap(tuple2.getValue())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Double>((ReactiveZSetCommands.ZAddCommand)command, (Double)value));
                }
                if (command.isReturnTotalChanged()) {
                    args = ZAddArgs.Builder.ch();
                }
                if (command.isUpsert()) {
                    args = args == null ? ZAddArgs.Builder.nx() : args.nx();
                } else {
                    ZAddArgs zAddArgs = args = args == null ? ZAddArgs.Builder.xx() : args.xx();
                }
                if (command.isGt()) {
                    ZAddArgs zAddArgs = args = args == null ? ZAddArgs.Builder.gt() : args.gt();
                }
                if (command.isLt()) {
                    args = args == null ? ZAddArgs.Builder.lt() : args.lt();
                }
            }
            ScoredValue[] values = (ScoredValue[])command.getTuples().stream().map(tuple -> ScoredValue.fromNullable(tuple.getScore(), ByteBuffer.wrap(tuple.getValue()))).toArray(ScoredValue[]::new);
            Mono<Long> result = args == null ? cmd.zadd(command.getKey(), values) : cmd.zadd(command.getKey(), args, (ScoredValue<V>[])values);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Long>((ReactiveZSetCommands.ZAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notEmpty(command.getValues(), "Values must not be null or empty");
            return cmd.zrem(command.getKey(), (ByteBuffer[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>((ReactiveZSetCommands.ZRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Member must not be null");
            Assert.notNull((Object)command.getIncrement(), "Increment value must not be null");
            return cmd.zincrby(command.getKey(), command.getIncrement().doubleValue(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>((ReactiveZSetCommands.ZIncrByCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<ByteBuffer>>> zRandMember(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZRandMemberCommand)command, cmd.zrandmember(command.getKey(), command.getCount()));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<Tuple>>> zRandMemberWithScore(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<Tuple>>((ReactiveZSetCommands.ZRandMemberCommand)command, cmd.zrandmemberWithScores(command.getKey(), command.getCount()).map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            Mono<Long> result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrank(command.getKey(), command.getValue()) : cmd.zrevrank(command.getKey(), command.getValue());
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>((ReactiveZSetCommands.ZRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            long start = LettuceConverters.getLowerBoundIndex(command.getRange());
            long stop = LettuceConverters.getUpperBoundIndex(command.getRange());
            Flux<Tuple> result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? (command.isWithScores() ? cmd.zrangeWithScores(command.getKey(), start, stop).map(this::toTuple) : cmd.zrange(command.getKey(), start, stop).map(value -> this.toTuple((ByteBuffer)value, Double.NaN))) : (command.isWithScores() ? cmd.zrevrangeWithScores(command.getKey(), start, stop).map(this::toTuple) : cmd.zrevrange(command.getKey(), start, stop).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<Tuple>>((ReactiveZSetCommands.ZRangeCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeStoreCommand, Mono<Long>>> zRangeStore(Publisher<ReactiveZSetCommands.ZRangeStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Mono<Long> result;
            block9: {
                Limit limit;
                block8: {
                    Assert.notNull((Object)command.getKey(), "Source key must not be null");
                    Assert.notNull((Object)command.getDestKey(), "Destination key must not be null");
                    Assert.notNull(command.getRange(), "Range must not be null");
                    Assert.notNull((Object)command.getLimit(), "Limit must not be null");
                    limit = LettuceConverters.toLimit(command.getLimit());
                    if (command.getDirection() != Sort.Direction.ASC) break block8;
                    switch (command.getRangeMode()) {
                        case ByScore: {
                            result = cmd.zrangestorebyscore(command.getDestKey(), command.getKey(), LettuceConverters.toRange(command.getRange()), limit);
                            break block9;
                        }
                        case ByLex: {
                            result = cmd.zrangestorebylex(command.getDestKey(), command.getKey(), RangeConverter.toRange(command.getRange()), limit);
                            break block9;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported value: " + command.getRangeMode());
                        }
                    }
                }
                switch (command.getRangeMode()) {
                    case ByScore: {
                        result = cmd.zrevrangestorebyscore(command.getDestKey(), command.getKey(), LettuceConverters.toRange(command.getRange()), limit);
                        break;
                    }
                    case ByLex: {
                        result = cmd.zrevrangestorebylex(command.getDestKey(), command.getKey(), RangeConverter.toRange(command.getRange()), limit);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported value: " + command.getRangeMode());
                    }
                }
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeStoreCommand, Mono<Long>>((ReactiveZSetCommands.ZRangeStoreCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Flux<Tuple> result;
            boolean isLimited;
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            boolean bl = isLimited = command.getLimit().isPresent() && !command.getLimit().get().isUnlimited();
            if (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC)) {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrangebyscoreWithScores(command.getKey(), range).map(this::toTuple) : cmd.zrangebyscoreWithScores(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(this::toTuple)) : (!isLimited ? cmd.zrangebyscore(command.getKey(), range).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)) : cmd.zrangebyscore(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            } else {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrevrangebyscoreWithScores(command.getKey(), range).map(this::toTuple) : cmd.zrevrangebyscoreWithScores(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(this::toTuple)) : (!isLimited ? cmd.zrevrangebyscore(command.getKey(), range).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)) : cmd.zrevrangebyscore(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<Tuple>>((ReactiveZSetCommands.ZRangeByScoreCommand)command, Flux.from(result)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getOptions(), "ScanOptions must not be null");
            Flux<Tuple> result = ScanStream.zscan(cmd, command.getKey(), LettuceConverters.toScanArgs(command.getOptions())).map(this::toTuple);
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux<Tuple>>((ReactiveRedisConnection.KeyScanCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Range range = RangeConverter.toRange(command.getRange());
            Mono<Long> result = cmd.zcount(command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>((ReactiveZSetCommands.ZCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>> zLexCount(Publisher<ReactiveZSetCommands.ZLexCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Mono<Long> result = cmd.zlexcount(command.getKey(), RangeConverter.toRange(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>((ReactiveZSetCommands.ZLexCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZPopCommand, Flux<Tuple>>> zPop(Publisher<ReactiveZSetCommands.ZPopCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Flux result = command.getCount() > 1L ? (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? cmd.zpopmin(command.getKey(), command.getCount()) : cmd.zpopmax(command.getKey(), command.getCount())) : (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? cmd.zpopmin(command.getKey()) : cmd.zpopmax(command.getKey())).flux();
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZPopCommand, Flux<Tuple>>((ReactiveZSetCommands.ZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux<Tuple>>> bZPop(Publisher<ReactiveZSetCommands.BZPopCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null");
            if (command.getTimeUnit() == TimeUnit.MILLISECONDS) {
                double timeout = TimeoutUtils.toDoubleSeconds(command.getTimeout(), command.getTimeUnit());
                Mono<ScoredValue> result = (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? cmd.bzpopmin(timeout, command.getKey()) : cmd.bzpopmax(timeout, command.getKey())).filter(Value::hasValue).map(Value::getValue);
                return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux<Tuple>>((ReactiveZSetCommands.BZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple).flux());
            }
            long timeout = command.getTimeUnit().toSeconds(command.getTimeout());
            Mono<ScoredValue> result = (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? cmd.bzpopmin(timeout, (K[])new ByteBuffer[]{command.getKey()}) : cmd.bzpopmax(timeout, (K[])new ByteBuffer[]{command.getKey()})).filter(Value::hasValue).map(Value::getValue);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux<Tuple>>((ReactiveZSetCommands.BZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple).flux());
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.zcard(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            return cmd.zscore(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>((ReactiveZSetCommands.ZScoreCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZMScoreCommand, Double>> zMScore(Publisher<ReactiveZSetCommands.ZMScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getValues(), "Values must not be null");
            return cmd.zmscore(command.getKey(), command.getValues().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveZSetCommands.ZMScoreCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Mono<Long> result = cmd.zremrangebyrank(command.getKey(), LettuceConverters.getLowerBoundIndex(command.getRange()), LettuceConverters.getUpperBoundIndex(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>((ReactiveZSetCommands.ZRemRangeByRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Range range = RangeConverter.toRange(command.getRange());
            Mono<Long> result = cmd.zremrangebyscore(command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>((ReactiveZSetCommands.ZRemRangeByScoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByLexCommand, Long>> zRemRangeByLex(Publisher<ReactiveZSetCommands.ZRemRangeByLexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Mono<Long> result = cmd.zremrangebylex(command.getKey(), RangeConverter.toRange(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByLexCommand, Long>((ReactiveZSetCommands.ZRemRangeByLexCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<ByteBuffer>>> zDiff(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getKeys(), "Keys must not be null or empty");
            ByteBuffer[] sourceKeys = command.getKeys().toArray(new ByteBuffer[0]);
            return new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZDiffCommand)command, cmd.zdiff(sourceKeys));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<Tuple>>> zDiffWithScores(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getKeys(), "Keys must not be null or empty");
            ByteBuffer[] sourceKeys = command.getKeys().toArray(new ByteBuffer[0]);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<Tuple>>((ReactiveZSetCommands.ZDiffCommand)command, cmd.zdiffWithScores(sourceKeys).map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZDiffStoreCommand, Long>> zDiffStore(Publisher<ReactiveZSetCommands.ZDiffStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ByteBuffer[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            return cmd.zdiffstore(command.getKey(), sourceKeys).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZDiffStoreCommand, Long>((ReactiveZSetCommands.ZDiffStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zInter(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Flux result = args != null ? cmd.zinter(args, (K[])sourceKeys) : cmd.zinter(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZAggregateCommand)command, result);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>> zInterWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Flux<ScoredValue<Tuple>> result = args != null ? cmd.zinterWithScores(args, (K[])sourceKeys) : cmd.zinterWithScores(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>((ReactiveZSetCommands.ZAggregateCommand)command, result.map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zInterStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Mono<Long> result = args != null ? cmd.zinterstore(command.getKey(), args, (K[])sourceKeys) : cmd.zinterstore(command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>((ReactiveZSetCommands.ZAggregateStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zUnion(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Flux result = args != null ? cmd.zunion(args, (K[])sourceKeys) : cmd.zunion(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZAggregateCommand)command, result);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>> zUnionWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Flux<ScoredValue<Tuple>> result = args != null ? cmd.zunionWithScores(args, (K[])sourceKeys) : cmd.zunionWithScores(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>((ReactiveZSetCommands.ZAggregateCommand)command, result.map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zUnionStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono<Long> result = args != null ? cmd.zunionstore(command.getKey(), args, (K[])sourceKeys) : cmd.zunionstore(command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>((ReactiveZSetCommands.ZAggregateStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null");
            Flux result = !command.getLimit().isUnlimited() ? (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex(command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit())) : cmd.zrevrangebylex(command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit()))) : (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex(command.getKey(), RangeConverter.toRange(command.getRange())) : cmd.zrevrangebylex(command.getKey(), RangeConverter.toRange(command.getRange())));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZRangeByLexCommand)command, result));
        }));
    }

    private static ZStoreArgs zStoreArgs(@Nullable Aggregate aggregate, @Nullable List<Double> weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        if (weights != null) {
            args.weights(weights.stream().mapToDouble(it -> it).toArray());
        }
        return args;
    }

    private Tuple toTuple(ScoredValue<ByteBuffer> scoredValue) {
        return (Tuple)scoredValue.map(it -> new DefaultTuple(ByteUtils.getBytes(it), scoredValue.getScore())).getValue();
    }

    private Tuple toTuple(ByteBuffer value, double score) {
        return new DefaultTuple(ByteUtils.getBytes(value), score);
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

