/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce.observability;

import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.common.KeyValues;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Locale;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationContext;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationConvention;
import org.springframework.data.redis.connection.lettuce.observability.RedisObservation;
import org.springframework.data.redis.connection.lettuce.observability.SocketAddressEndpoint;

record DefaultLettuceObservationConvention(boolean includeCommandArgsInSpanTags) implements LettuceObservationConvention
{
    @Override
    public KeyValues getLowCardinalityKeyValues(LettuceObservationContext context) {
        Tracing.Endpoint ep = context.getRequiredEndpoint();
        KeyValues keyValues = KeyValues.of(RedisObservation.LowCardinalityCommandKeyNames.DATABASE_SYSTEM.withValue("redis"), RedisObservation.LowCardinalityCommandKeyNames.REDIS_COMMAND.withValue(context.getRequiredCommand().getType().name()));
        if (ep instanceof SocketAddressEndpoint) {
            SocketAddressEndpoint endpoint = (SocketAddressEndpoint)ep;
            SocketAddress socketAddress = endpoint.socketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inet = (InetSocketAddress)socketAddress;
                keyValues = keyValues.and(KeyValues.of(RedisObservation.LowCardinalityCommandKeyNames.NET_SOCK_PEER_ADDR.withValue(inet.getHostString()), RedisObservation.LowCardinalityCommandKeyNames.NET_SOCK_PEER_PORT.withValue("" + inet.getPort()), RedisObservation.LowCardinalityCommandKeyNames.NET_TRANSPORT.withValue("IP.TCP")));
            } else {
                keyValues = keyValues.and(KeyValues.of(RedisObservation.LowCardinalityCommandKeyNames.NET_PEER_NAME.withValue(endpoint.toString()), RedisObservation.LowCardinalityCommandKeyNames.NET_TRANSPORT.withValue("Unix")));
            }
        }
        return keyValues;
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(LettuceObservationContext context) {
        RedisCommand<?, ?, ?> command = context.getRequiredCommand();
        if (this.includeCommandArgsInSpanTags && command.getArgs() != null) {
            return KeyValues.of(RedisObservation.HighCardinalityCommandKeyNames.STATEMENT.withValue(command.getType().name() + " " + command.getArgs().toCommandString()));
        }
        return KeyValues.empty();
    }

    @Override
    public String getContextualName(LettuceObservationContext context) {
        return context.getRequiredCommand().getType().name().toLowerCase(Locale.ROOT);
    }
}

