/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.StringJoiner;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScanOptions {
    public static ScanOptions NONE = new ScanOptions(null, null, null);
    @Nullable
    private final Long count;
    @Nullable
    private final String pattern;
    @Nullable
    private final byte[] bytePattern;

    ScanOptions(@Nullable Long count, @Nullable String pattern, @Nullable byte[] bytePattern) {
        this.count = count;
        this.pattern = pattern;
        this.bytePattern = bytePattern;
    }

    public static ScanOptionsBuilder scanOptions() {
        return new ScanOptionsBuilder();
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    @Nullable
    public String getPattern() {
        if (this.bytePattern != null && this.pattern == null) {
            return new String(this.bytePattern);
        }
        return this.pattern;
    }

    @Nullable
    public byte[] getBytePattern() {
        if (this.bytePattern == null && this.pattern != null) {
            return this.pattern.getBytes();
        }
        return this.bytePattern;
    }

    public String toOptionString() {
        String pattern;
        if (this.equals(NONE)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        if (this.getCount() != null) {
            joiner.add("'count' " + this.getCount());
        }
        if (StringUtils.hasText(pattern = this.getPattern())) {
            joiner.add("'match' '" + pattern + "'");
        }
        return joiner.toString();
    }

    public static class ScanOptionsBuilder {
        @Nullable
        Long count;
        @Nullable
        String pattern;
        @Nullable
        byte[] bytePattern;
        @Nullable
        DataType type;

        ScanOptionsBuilder() {
        }

        public ScanOptionsBuilder count(long count) {
            this.count = count;
            return this;
        }

        public ScanOptionsBuilder match(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ScanOptionsBuilder match(byte[] pattern) {
            this.bytePattern = pattern;
            return this;
        }

        public ScanOptionsBuilder type(DataType type) {
            Assert.notNull((Object)type, "Type must not be null Use NONE instead");
            this.type = type;
            return this;
        }

        public ScanOptionsBuilder type(String type) {
            Assert.notNull((Object)type, "Type must not be null");
            return this.type(DataType.fromCode(type));
        }

        public ScanOptions build() {
            if (this.type != null && !DataType.NONE.equals((Object)this.type)) {
                return new KeyScanOptions(this.count, this.pattern, this.bytePattern, this.type.code());
            }
            return new ScanOptions(this.count, this.pattern, this.bytePattern);
        }
    }
}

