/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.DefaultRedisSerializationContext;
import org.springframework.data.redis.serializer.DefaultSerializationPair;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializerToSerializationPairAdapter;
import org.springframework.util.Assert;

public interface RedisSerializationContext<K, V> {
    public static <K, V> RedisSerializationContextBuilder<K, V> newSerializationContext() {
        return new DefaultRedisSerializationContext.DefaultRedisSerializationContextBuilder();
    }

    public static <K, V> RedisSerializationContextBuilder<K, V> newSerializationContext(RedisSerializer<?> defaultSerializer) {
        Assert.notNull(defaultSerializer, "DefaultSerializer must not be null");
        return RedisSerializationContext.newSerializationContext(SerializationPair.fromSerializer(defaultSerializer));
    }

    public static <K, V> RedisSerializationContextBuilder<K, V> newSerializationContext(SerializationPair<?> serializationPair) {
        Assert.notNull(serializationPair, "SerializationPair must not be null");
        return new DefaultRedisSerializationContext.DefaultRedisSerializationContextBuilder().key(serializationPair).value(serializationPair).hashKey(serializationPair).hashValue(serializationPair);
    }

    @Deprecated
    public static RedisSerializationContext<byte[], byte[]> raw() {
        return RedisSerializationContext.byteArray();
    }

    public static RedisSerializationContext<byte[], byte[]> byteArray() {
        return RedisSerializationContext.just(RedisSerializerToSerializationPairAdapter.byteArray());
    }

    public static RedisSerializationContext<ByteBuffer, ByteBuffer> byteBuffer() {
        return RedisSerializationContext.just(RedisSerializerToSerializationPairAdapter.byteBuffer());
    }

    public static RedisSerializationContext<Object, Object> java() {
        return RedisSerializationContext.fromSerializer(RedisSerializer.java());
    }

    public static RedisSerializationContext<Object, Object> java(ClassLoader classLoader) {
        return RedisSerializationContext.fromSerializer(RedisSerializer.java(classLoader));
    }

    public static RedisSerializationContext<String, String> string() {
        return RedisSerializationContext.fromSerializer(RedisSerializer.string());
    }

    public static <T> RedisSerializationContext<T, T> fromSerializer(RedisSerializer<T> serializer) {
        return RedisSerializationContext.just(SerializationPair.fromSerializer(serializer));
    }

    public static <T> RedisSerializationContext<T, T> just(SerializationPair<T> serializationPair) {
        return RedisSerializationContext.newSerializationContext(serializationPair).build();
    }

    public SerializationPair<K> getKeySerializationPair();

    public SerializationPair<V> getValueSerializationPair();

    public <HK> SerializationPair<HK> getHashKeySerializationPair();

    public <HV> SerializationPair<HV> getHashValueSerializationPair();

    public SerializationPair<String> getStringSerializationPair();

    public static interface SerializationPair<T> {
        public static <T> SerializationPair<T> fromSerializer(RedisSerializer<T> serializer) {
            Assert.notNull(serializer, "RedisSerializer must not be null");
            return new RedisSerializerToSerializationPairAdapter<T>(serializer);
        }

        public static <T> SerializationPair<T> just(RedisElementReader<? extends T> reader, RedisElementWriter<? extends T> writer) {
            Assert.notNull(reader, "RedisElementReader must not be null");
            Assert.notNull(writer, "RedisElementWriter must not be null");
            return new DefaultSerializationPair<T>(reader, writer);
        }

        @Deprecated
        public static <T> SerializationPair<T> raw() {
            return RedisSerializerToSerializationPairAdapter.raw();
        }

        public static SerializationPair<byte[]> byteArray() {
            return RedisSerializerToSerializationPairAdapter.byteArray();
        }

        public static SerializationPair<ByteBuffer> byteBuffer() {
            return RedisSerializerToSerializationPairAdapter.byteBuffer();
        }

        public RedisElementReader<T> getReader();

        default public T read(ByteBuffer buffer) {
            return this.getReader().read(buffer);
        }

        public RedisElementWriter<T> getWriter();

        default public ByteBuffer write(T element) {
            return this.getWriter().write(element);
        }
    }

    public static interface RedisSerializationContextBuilder<K, V> {
        public RedisSerializationContextBuilder<K, V> key(SerializationPair<K> var1);

        default public RedisSerializationContextBuilder<K, V> key(RedisElementReader<K> reader, RedisElementWriter<K> writer) {
            this.key(SerializationPair.just(reader, writer));
            return this;
        }

        default public RedisSerializationContextBuilder<K, V> key(RedisSerializer<K> serializer) {
            this.key(SerializationPair.fromSerializer(serializer));
            return this;
        }

        public RedisSerializationContextBuilder<K, V> value(SerializationPair<V> var1);

        default public RedisSerializationContextBuilder<K, V> value(RedisElementReader<V> reader, RedisElementWriter<V> writer) {
            this.value(SerializationPair.just(reader, writer));
            return this;
        }

        default public RedisSerializationContextBuilder<K, V> value(RedisSerializer<V> serializer) {
            this.value(SerializationPair.fromSerializer(serializer));
            return this;
        }

        public RedisSerializationContextBuilder<K, V> hashKey(SerializationPair<?> var1);

        default public RedisSerializationContextBuilder<K, V> hashKey(RedisElementReader<? extends Object> reader, RedisElementWriter<? extends Object> writer) {
            this.hashKey(SerializationPair.just(reader, writer));
            return this;
        }

        default public RedisSerializationContextBuilder<K, V> hashKey(RedisSerializer<? extends Object> serializer) {
            this.hashKey(SerializationPair.fromSerializer(serializer));
            return this;
        }

        public RedisSerializationContextBuilder<K, V> hashValue(SerializationPair<?> var1);

        default public RedisSerializationContextBuilder<K, V> hashValue(RedisElementReader<? extends Object> reader, RedisElementWriter<? extends Object> writer) {
            this.hashValue(SerializationPair.just(reader, writer));
            return this;
        }

        default public RedisSerializationContextBuilder<K, V> hashValue(RedisSerializer<? extends Object> serializer) {
            this.hashValue(SerializationPair.fromSerializer(serializer));
            return this;
        }

        public RedisSerializationContextBuilder<K, V> string(SerializationPair<String> var1);

        default public RedisSerializationContextBuilder<K, V> string(RedisElementReader<String> reader, RedisElementWriter<String> writer) {
            this.string(SerializationPair.just(reader, writer));
            return this;
        }

        default public RedisSerializationContextBuilder<K, V> string(RedisSerializer<String> serializer) {
            this.string(SerializationPair.fromSerializer(serializer));
            return this;
        }

        public RedisSerializationContext<K, V> build();
    }
}

