/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.coyote.Response;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.http.server.reactive.TomcatHeadersAdapter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class TomcatHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public TomcatHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest createRequest(HttpServletRequest request2, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.state(this.getServletPath() != null, "Servlet path is not initialized");
        return new TomcatServerHttpRequest(request2, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext asyncContext, ServletServerHttpRequest request2) throws IOException {
        return new TomcatServerHttpResponse(response, asyncContext, this.getDataBufferFactory(), this.getBufferSize(), request2);
    }

    private static final class TomcatServerHttpRequest
    extends ServletServerHttpRequest {
        private static final Field COYOTE_REQUEST_FIELD;
        private final int bufferSize;
        private final DataBufferFactory factory;

        TomcatServerHttpRequest(HttpServletRequest request2, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(TomcatServerHttpRequest.createTomcatHttpHeaders(request2), request2, context, servletPath, factory, bufferSize);
            this.factory = factory;
            this.bufferSize = bufferSize;
        }

        private static MultiValueMap<String, String> createTomcatHttpHeaders(HttpServletRequest request2) {
            RequestFacade requestFacade = TomcatServerHttpRequest.getRequestFacade(request2);
            Request connectorRequest = (Request)ReflectionUtils.getField(COYOTE_REQUEST_FIELD, requestFacade);
            Assert.state(connectorRequest != null, "No Tomcat connector request");
            org.apache.coyote.Request tomcatRequest = connectorRequest.getCoyoteRequest();
            return new TomcatHeadersAdapter(tomcatRequest.getMimeHeaders());
        }

        private static RequestFacade getRequestFacade(HttpServletRequest request2) {
            if (request2 instanceof RequestFacade) {
                RequestFacade facade = (RequestFacade)request2;
                return facade;
            }
            if (request2 instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request2;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return TomcatServerHttpRequest.getRequestFacade(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request2.getClass() + "] to org.apache.catalina.connector.RequestFacade");
        }

        @Override
        protected DataBuffer readFromInputStream() throws IOException {
            ServletInputStream servletInputStream = this.getInputStream();
            if (!(servletInputStream instanceof CoyoteInputStream)) {
                return super.readFromInputStream();
            }
            CoyoteInputStream coyoteInputStream = (CoyoteInputStream)servletInputStream;
            ByteBuffer byteBuffer = this.factory.isDirect() ? ByteBuffer.allocateDirect(this.bufferSize) : ByteBuffer.allocate(this.bufferSize);
            int read = coyoteInputStream.read(byteBuffer);
            this.logBytesRead(read);
            if (read > 0) {
                return this.factory.wrap(byteBuffer);
            }
            if (read == -1) {
                return EOF_BUFFER;
            }
            return AbstractListenerReadPublisher.EMPTY_BUFFER;
        }

        static {
            Field field = ReflectionUtils.findField(RequestFacade.class, "request");
            Assert.state(field != null, "Incompatible Tomcat implementation");
            ReflectionUtils.makeAccessible(field);
            COYOTE_REQUEST_FIELD = field;
        }
    }

    private static final class TomcatServerHttpResponse
    extends ServletServerHttpResponse {
        private static final Field COYOTE_RESPONSE_FIELD;

        TomcatServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize, ServletServerHttpRequest request2) throws IOException {
            super(TomcatServerHttpResponse.createTomcatHttpHeaders(response), response, context, factory, bufferSize, request2);
        }

        private static HttpHeaders createTomcatHttpHeaders(HttpServletResponse response) {
            ResponseFacade responseFacade = TomcatServerHttpResponse.getResponseFacade(response);
            org.apache.catalina.connector.Response connectorResponse = (org.apache.catalina.connector.Response)ReflectionUtils.getField(COYOTE_RESPONSE_FIELD, responseFacade);
            Assert.state(connectorResponse != null, "No Tomcat connector response");
            Response tomcatResponse = connectorResponse.getCoyoteResponse();
            TomcatHeadersAdapter headers = new TomcatHeadersAdapter(tomcatResponse.getMimeHeaders());
            return new HttpHeaders(headers);
        }

        private static ResponseFacade getResponseFacade(HttpServletResponse response) {
            if (response instanceof ResponseFacade) {
                ResponseFacade facade = (ResponseFacade)response;
                return facade;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return TomcatServerHttpResponse.getResponseFacade(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to org.apache.catalina.connector.ResponseFacade");
        }

        @Override
        protected void applyHeaders() {
            this.adaptHeaders(true);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            if (!(servletOutputStream instanceof CoyoteOutputStream)) {
                return super.writeToOutputStream(dataBuffer);
            }
            CoyoteOutputStream coyoteOutputStream = (CoyoteOutputStream)servletOutputStream;
            ByteBuffer input = dataBuffer.toByteBuffer();
            int len = input.remaining();
            coyoteOutputStream.write(input);
            return len;
        }

        static {
            Field field = ReflectionUtils.findField(ResponseFacade.class, "response");
            Assert.state(field != null, "Incompatible Tomcat implementation");
            ReflectionUtils.makeAccessible(field);
            COYOTE_RESPONSE_FIELD = field;
        }
    }
}

