/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PassThroughFilterChain
implements FilterChain {
    @Nullable
    private Filter filter;
    @Nullable
    private FilterChain nextFilterChain;
    @Nullable
    private Servlet servlet;

    public PassThroughFilterChain(Filter filter2, FilterChain nextFilterChain) {
        Assert.notNull((Object)filter2, "Filter must not be null");
        Assert.notNull((Object)nextFilterChain, "'FilterChain must not be null");
        this.filter = filter2;
        this.nextFilterChain = nextFilterChain;
    }

    public PassThroughFilterChain(Servlet servlet) {
        Assert.notNull((Object)servlet, "Servlet must not be null");
        this.servlet = servlet;
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response) throws ServletException, IOException {
        if (this.filter != null) {
            this.filter.doFilter(request2, response, this.nextFilterChain);
        } else {
            Assert.state(this.servlet != null, "Neither a Filter nor a Servlet has been set");
            this.servlet.service(request2, response);
        }
    }
}

