/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.function.SingletonSupplier;

final class DeferringObservationAuthorizationManager<T>
implements AuthorizationManager<T> {
    private final Supplier<AuthorizationManager<T>> delegate = SingletonSupplier.of(() -> {
        ObservationRegistry registry = provider.getIfAvailable(() -> ObservationRegistry.NOOP);
        if (registry.isNoop()) {
            return delegate;
        }
        return new ObservationAuthorizationManager(registry, delegate);
    });

    DeferringObservationAuthorizationManager(ObjectProvider<ObservationRegistry> provider, AuthorizationManager<T> delegate) {
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
        return this.delegate.get().check(authentication, object);
    }
}

