/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherDsl;
import org.springframework.security.config.annotation.web.AuthorizeRequestsDsl;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0004J#\u0010#\u001a\u0018\u0012\u000e\u0012\f0%R\b\u0012\u0004\u0012\u00020'0&\u0012\u0004\u0012\u00020\u001b0$H\u0000\u00a2\u0006\u0002\b(J\u001f\u0010)\u001a\u00020\u00042\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040+\"\u00020\u0004\u00a2\u0006\u0002\u0010,J\u001f\u0010-\u001a\u00020\u00042\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040+\"\u00020\u0004\u00a2\u0006\u0002\u0010,J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0014\u0010\u0018\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\f\u00a8\u00063"}, d2={"Lorg/springframework/security/config/annotation/web/AuthorizeRequestsDsl;", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl;", "()V", "HANDLER_MAPPING_INTROSPECTOR", "", "HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME", "MVC_PRESENT", "", "PATTERN_TYPE", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$PatternType;", "anonymous", "getAnonymous", "()Ljava/lang/String;", "authenticated", "getAuthenticated", "authorizationRules", "", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$AuthorizationRule;", "denyAll", "getDenyAll", "fullyAuthenticated", "getFullyAuthenticated", "permitAll", "getPermitAll", "rememberMe", "getRememberMe", "authorize", "", "pattern", "access", "servletPath", "method", "Lorg/springframework/http/HttpMethod;", "matches", "Lorg/springframework/security/web/util/matcher/RequestMatcher;", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/annotation/web/configurers/ExpressionUrlAuthorizationConfigurer$ExpressionInterceptUrlRegistry;", "Lorg/springframework/security/config/annotation/web/configurers/ExpressionUrlAuthorizationConfigurer;", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "get$spring_security_config", "hasAnyAuthority", "authorities", "", "([Ljava/lang/String;)Ljava/lang/String;", "hasAnyRole", "roles", "hasAuthority", "authority", "hasRole", "role", "spring-security-config"})
public final class AuthorizeRequestsDsl
extends AbstractRequestMatcherDsl {
    @NotNull
    private final List<AbstractRequestMatcherDsl.AuthorizationRule> authorizationRules = new ArrayList();
    @NotNull
    private final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME;
    @NotNull
    private final String HANDLER_MAPPING_INTROSPECTOR;
    private final boolean MVC_PRESENT = ClassUtils.isPresent(this.HANDLER_MAPPING_INTROSPECTOR, AuthorizeRequestsDsl.class.getClassLoader());
    @NotNull
    private final AbstractRequestMatcherDsl.PatternType PATTERN_TYPE = this.MVC_PRESENT ? AbstractRequestMatcherDsl.PatternType.MVC : AbstractRequestMatcherDsl.PatternType.ANT;
    @NotNull
    private final String permitAll;
    @NotNull
    private final String anonymous;
    @NotNull
    private final String rememberMe;
    @NotNull
    private final String denyAll;
    @NotNull
    private final String authenticated;
    @NotNull
    private final String fullyAuthenticated;

    public AuthorizeRequestsDsl() {
        this.HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
        this.HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
        this.permitAll = "permitAll";
        this.anonymous = "anonymous";
        this.rememberMe = "rememberMe";
        this.denyAll = "denyAll";
        this.authenticated = "authenticated";
        this.fullyAuthenticated = "fullyAuthenticated";
    }

    public final void authorize(@NotNull RequestMatcher matches, @NotNull String access) {
        Intrinsics.checkNotNullParameter((Object)matches, (String)"matches");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.MatcherAuthorizationRule(matches, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeRequestsDsl authorizeRequestsDsl, RequestMatcher requestMatcher, String string, int n, Object object) {
        if ((n & 1) != 0) {
            RequestMatcher requestMatcher2 = AnyRequestMatcher.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)requestMatcher2, (String)"INSTANCE");
            requestMatcher = requestMatcher2;
        }
        authorizeRequestsDsl.authorize(requestMatcher, string);
    }

    public final void authorize(@NotNull String pattern, @NotNull String access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationRule(pattern, this.PATTERN_TYPE, null, null, access, 12, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull String access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationRule(pattern, this.PATTERN_TYPE, null, method, access, 4, null));
    }

    public final void authorize(@NotNull String pattern, @NotNull String servletPath, @NotNull String access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationRule(pattern, this.PATTERN_TYPE, servletPath, null, access, 8, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull String servletPath, @NotNull String access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationRule(pattern, this.PATTERN_TYPE, servletPath, method, access));
    }

    @NotNull
    public final String hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return "hasAuthority('" + authority + "')";
    }

    @NotNull
    public final String hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        String anyAuthorities = ArraysKt.joinToString$default((Object[])authorities, (CharSequence)"','", null, null, (int)0, null, null, (int)62, null);
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    @NotNull
    public final String hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        return "hasRole('" + role + "')";
    }

    @NotNull
    public final String hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        String anyRoles = ArraysKt.joinToString$default((Object[])roles, (CharSequence)"','", null, null, (int)0, null, null, (int)62, null);
        return "hasAnyRole('" + anyRoles + "')";
    }

    @NotNull
    public final String getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final String getAnonymous() {
        return this.anonymous;
    }

    @NotNull
    public final String getRememberMe() {
        return this.rememberMe;
    }

    @NotNull
    public final String getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final String getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final String getFullyAuthenticated() {
        return this.fullyAuthenticated;
    }

    @NotNull
    public final Function1<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry, Unit> get$spring_security_config() {
        return (Function1)new Function1<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry, Unit>(this){
            final /* synthetic */ AuthorizeRequestsDsl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
                Iterable iterable = AuthorizeRequestsDsl.access$getAuthorizationRules$p(this.this$0);
                AuthorizeRequestsDsl authorizeRequestsDsl = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AbstractRequestMatcherDsl.AuthorizationRule rule = (AbstractRequestMatcherDsl.AuthorizationRule)element$iv;
                    boolean bl = false;
                    AbstractRequestMatcherDsl.AuthorizationRule authorizationRule = rule;
                    if (authorizationRule instanceof AbstractRequestMatcherDsl.MatcherAuthorizationRule) {
                        RequestMatcher[] requestMatcherArray = new RequestMatcher[]{((AbstractRequestMatcherDsl.MatcherAuthorizationRule)rule).getMatcher()};
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(rule.getRule());
                        continue;
                    }
                    if (!(authorizationRule instanceof AbstractRequestMatcherDsl.PatternAuthorizationRule)) continue;
                    switch (get.WhenMappings.$EnumSwitchMapping$0[((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getPatternType().ordinal()]) {
                        case 1: {
                            String[] stringArray = new String[]{((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getPattern()};
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getHttpMethod(), stringArray)).access(rule.getRule());
                            break;
                        }
                        case 2: {
                            HandlerMappingIntrospector introspector;
                            Intrinsics.checkNotNullExpressionValue((Object)requests.getApplicationContext().getBean(AuthorizeRequestsDsl.access$getHANDLER_MAPPING_INTROSPECTOR_BEAN_NAME$p(authorizeRequestsDsl), HandlerMappingIntrospector.class), (String)"requests.applicationCont\u2026Introspector::class.java)");
                            MvcRequestMatcher mvcMatcher = new MvcRequestMatcher.Builder(introspector).servletPath(((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getServletPath()).pattern(((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getPattern());
                            mvcMatcher.setMethod(((AbstractRequestMatcherDsl.PatternAuthorizationRule)rule).getHttpMethod());
                            RequestMatcher[] requestMatcherArray = new RequestMatcher[]{mvcMatcher};
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(rule.getRule());
                        }
                    }
                }
            }
        };
    }

    public static final /* synthetic */ List access$getAuthorizationRules$p(AuthorizeRequestsDsl $this) {
        return $this.authorizationRules;
    }

    public static final /* synthetic */ String access$getHANDLER_MAPPING_INTROSPECTOR_BEAN_NAME$p(AuthorizeRequestsDsl $this) {
        return $this.HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME;
    }
}

