/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.CachingUserDetailsService;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractUserDetailsServiceBeanDefinitionParser
implements BeanDefinitionParser {
    static final String CACHE_REF = "cache-ref";
    public static final String CACHING_SUFFIX = ".caching";

    protected abstract String getBeanClassName(Element var1);

    protected abstract void doParse(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(this.getBeanClassName(element));
        this.doParse(element, parserContext, builder);
        RootBeanDefinition userService = (RootBeanDefinition)builder.getBeanDefinition();
        String beanId = this.resolveId(element, userService, parserContext);
        parserContext.registerBeanComponent(new BeanComponentDefinition(userService, beanId));
        String cacheRef = element.getAttribute(CACHE_REF);
        if (StringUtils.hasText(cacheRef)) {
            BeanDefinitionBuilder cachingUSBuilder = BeanDefinitionBuilder.rootBeanDefinition(CachingUserDetailsService.class);
            cachingUSBuilder.addConstructorArgReference(beanId);
            cachingUSBuilder.addPropertyValue("userCache", new RuntimeBeanReference(cacheRef));
            AbstractBeanDefinition cachingUserService = cachingUSBuilder.getBeanDefinition();
            parserContext.registerBeanComponent(new BeanComponentDefinition(cachingUserService, beanId + CACHING_SUFFIX));
        }
        return null;
    }

    private String resolveId(Element element, AbstractBeanDefinition definition, ParserContext pc) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (pc.isNested()) {
            if (!StringUtils.hasText(id)) {
                id = pc.getReaderContext().generateBeanName(definition);
            }
            BeanDefinition container = pc.getContainingBeanDefinition();
            container.getPropertyValues().add("userDetailsService", new RuntimeBeanReference(id));
        }
        if (StringUtils.hasText(id)) {
            return id;
        }
        if (pc.getRegistry().containsBeanDefinition("org.springframework.security.userDetailsService")) {
            throw new BeanDefinitionStoreException("No id supplied and another bean is already registered as org.springframework.security.userDetailsService");
        }
        return "org.springframework.security.userDetailsService";
    }
}

