/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.util.Assert;

public class UserDetailsMapFactoryBean
implements FactoryBean<Collection<UserDetails>> {
    private final Map<String, String> userProperties;

    public UserDetailsMapFactoryBean(Map<String, String> userProperties) {
        Assert.notNull(userProperties, "userProperties cannot be null");
        this.userProperties = userProperties;
    }

    @Override
    public Collection<UserDetails> getObject() {
        ArrayList<UserDetails> users = new ArrayList<UserDetails>(this.userProperties.size());
        UserAttributeEditor editor = new UserAttributeEditor();
        this.userProperties.forEach((name, property) -> {
            editor.setAsText((String)property);
            UserAttribute attr = (UserAttribute)editor.getValue();
            Assert.state(attr != null, () -> "The entry with username '" + name + "' and value '" + property + "' could not be converted to a UserDetails.");
            String password = attr.getPassword();
            boolean disabled = !attr.isEnabled();
            List<GrantedAuthority> authorities = attr.getAuthorities();
            users.add(User.withUsername(name).password(password).disabled(disabled).authorities(authorities).build());
        });
        return users;
    }

    @Override
    public Class<?> getObjectType() {
        return Collection.class;
    }
}

