/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class RequestMatcherDelegatingAccessDeniedHandler
implements AccessDeniedHandler {
    private final LinkedHashMap<RequestMatcher, AccessDeniedHandler> handlers;
    private final AccessDeniedHandler defaultHandler;

    public RequestMatcherDelegatingAccessDeniedHandler(LinkedHashMap<RequestMatcher, AccessDeniedHandler> handlers, AccessDeniedHandler defaultHandler) {
        Assert.notEmpty(handlers, "handlers cannot be null or empty");
        Assert.notNull((Object)defaultHandler, "defaultHandler cannot be null");
        this.handlers = new LinkedHashMap<RequestMatcher, AccessDeniedHandler>(handlers);
        this.defaultHandler = defaultHandler;
    }

    @Override
    public void handle(HttpServletRequest request2, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        for (Map.Entry<RequestMatcher, AccessDeniedHandler> entry : this.handlers.entrySet()) {
            RequestMatcher matcher = entry.getKey();
            if (!matcher.matches(request2)) continue;
            AccessDeniedHandler handler = entry.getValue();
            handler.handle(request2, response, accessDeniedException);
            return;
        }
        this.defaultHandler.handle(request2, response, accessDeniedException);
    }
}

