/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.AbstractVariableEvaluationContextPostProcessor;
import org.springframework.security.web.access.expression.WebExpressionConfigAttribute;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class ExpressionBasedFilterInvocationSecurityMetadataSource
extends DefaultFilterInvocationSecurityMetadataSource {
    private static final Log logger = LogFactory.getLog(ExpressionBasedFilterInvocationSecurityMetadataSource.class);

    public ExpressionBasedFilterInvocationSecurityMetadataSource(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        super(ExpressionBasedFilterInvocationSecurityMetadataSource.processMap(requestMap, expressionHandler.getExpressionParser()));
        Assert.notNull(expressionHandler, "A non-null SecurityExpressionHandler is required");
    }

    private static LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> processMap(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, ExpressionParser parser) {
        Assert.notNull((Object)parser, "SecurityExpressionHandler returned a null parser object");
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> processed = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>(requestMap);
        requestMap.forEach((request2, value) -> ExpressionBasedFilterInvocationSecurityMetadataSource.process(parser, request2, value, processed::put));
        return processed;
    }

    private static void process(ExpressionParser parser, RequestMatcher request2, Collection<ConfigAttribute> value, BiConsumer<RequestMatcher, Collection<ConfigAttribute>> consumer) {
        String expression = ExpressionBasedFilterInvocationSecurityMetadataSource.getExpression(request2, value);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessage.format("Adding web access control expression [%s] for %s", (Object)expression, (Object)request2));
        }
        AbstractVariableEvaluationContextPostProcessor postProcessor = ExpressionBasedFilterInvocationSecurityMetadataSource.createPostProcessor(request2);
        ArrayList<WebExpressionConfigAttribute> processed = new ArrayList<WebExpressionConfigAttribute>(1);
        try {
            processed.add(new WebExpressionConfigAttribute(parser.parseExpression(expression), postProcessor));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse expression '" + expression + "'");
        }
        consumer.accept(request2, processed);
    }

    private static String getExpression(RequestMatcher request2, Collection<ConfigAttribute> value) {
        Assert.isTrue(value.size() == 1, () -> "Expected a single expression attribute for " + request2);
        return value.toArray(new ConfigAttribute[1])[0].getAttribute();
    }

    private static AbstractVariableEvaluationContextPostProcessor createPostProcessor(RequestMatcher request2) {
        return new RequestVariablesExtractorEvaluationContextPostProcessor(request2);
    }

    static class RequestVariablesExtractorEvaluationContextPostProcessor
    extends AbstractVariableEvaluationContextPostProcessor {
        private final RequestMatcher matcher;

        RequestVariablesExtractorEvaluationContextPostProcessor(RequestMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        Map<String, String> extractVariables(HttpServletRequest request2) {
            return this.matcher.matcher(request2).getVariables();
        }
    }

    static class AntPathMatcherEvaluationContextPostProcessor
    extends AbstractVariableEvaluationContextPostProcessor {
        private final AntPathRequestMatcher matcher;

        AntPathMatcherEvaluationContextPostProcessor(AntPathRequestMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        Map<String, String> extractVariables(HttpServletRequest request2) {
            return this.matcher.matcher(request2).getVariables();
        }
    }
}

