/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public abstract class AbstractPreAuthenticatedProcessingFilter
extends GenericFilterBean
implements ApplicationEventPublisherAware {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ApplicationEventPublisher eventPublisher = null;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager = null;
    private boolean continueFilterChainOnUnsuccessfulAuthentication = true;
    private boolean checkForPrincipalChanges;
    private boolean invalidateSessionOnPrincipalChange = true;
    private AuthenticationSuccessHandler authenticationSuccessHandler = null;
    private AuthenticationFailureHandler authenticationFailureHandler = null;
    private RequestMatcher requiresAuthenticationRequestMatcher = new PreAuthenticatedProcessingRequestMatcher();
    private SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();

    @Override
    public void afterPropertiesSet() {
        try {
            super.afterPropertiesSet();
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
        Assert.notNull((Object)this.authenticationManager, "An AuthenticationManager must be set");
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresAuthenticationRequestMatcher.matches((HttpServletRequest)request2)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(LogMessage.of(() -> "Authenticating " + this.securityContextHolderStrategy.getContext().getAuthentication()));
            }
            this.doAuthenticate((HttpServletRequest)request2, (HttpServletResponse)response);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace(LogMessage.format("Did not authenticate since request did not match [%s]", (Object)this.requiresAuthenticationRequestMatcher));
        }
        chain.doFilter(request2, response);
    }

    protected boolean principalChanged(HttpServletRequest request2, Authentication currentAuthentication) {
        Object principal = this.getPreAuthenticatedPrincipal(request2);
        if (principal instanceof String && currentAuthentication.getName().equals(principal)) {
            return false;
        }
        if (principal != null && principal.equals(currentAuthentication.getPrincipal())) {
            return false;
        }
        this.logger.debug(LogMessage.format("Pre-authenticated principal has changed to %s and will be reauthenticated", principal));
        return true;
    }

    private void doAuthenticate(HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
        block3: {
            Object principal = this.getPreAuthenticatedPrincipal(request2);
            if (principal == null) {
                this.logger.debug("No pre-authenticated principal found in request");
                return;
            }
            this.logger.debug(LogMessage.format("preAuthenticatedPrincipal = %s, trying to authenticate", principal));
            Object credentials = this.getPreAuthenticatedCredentials(request2);
            try {
                PreAuthenticatedAuthenticationToken authenticationRequest = new PreAuthenticatedAuthenticationToken(principal, credentials);
                authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails(request2));
                Authentication authenticationResult = this.authenticationManager.authenticate(authenticationRequest);
                this.successfulAuthentication(request2, response, authenticationResult);
            }
            catch (AuthenticationException ex) {
                this.unsuccessfulAuthentication(request2, response, ex);
                if (this.continueFilterChainOnUnsuccessfulAuthentication) break block3;
                throw ex;
            }
        }
    }

    protected void successfulAuthentication(HttpServletRequest request2, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        this.logger.debug(LogMessage.format("Authentication success: %s", (Object)authResult));
        SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
        context.setAuthentication(authResult);
        this.securityContextHolderStrategy.setContext(context);
        this.securityContextRepository.saveContext(context, request2, response);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
        if (this.authenticationSuccessHandler != null) {
            this.authenticationSuccessHandler.onAuthenticationSuccess(request2, response, authResult);
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request2, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        this.securityContextHolderStrategy.clearContext();
        this.logger.debug("Cleared security context due to exception", failed);
        request2.setAttribute("SPRING_SECURITY_LAST_EXCEPTION", failed);
        if (this.authenticationFailureHandler != null) {
            this.authenticationFailureHandler.onAuthenticationFailure(request2, response, failed);
        }
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher anApplicationEventPublisher) {
        this.eventPublisher = anApplicationEventPublisher;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, "securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, "AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    protected AuthenticationDetailsSource<HttpServletRequest, ?> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setContinueFilterChainOnUnsuccessfulAuthentication(boolean shouldContinue) {
        this.continueFilterChainOnUnsuccessfulAuthentication = shouldContinue;
    }

    public void setCheckForPrincipalChanges(boolean checkForPrincipalChanges) {
        this.checkForPrincipalChanges = checkForPrincipalChanges;
    }

    public void setInvalidateSessionOnPrincipalChange(boolean invalidateSessionOnPrincipalChange) {
        this.invalidateSessionOnPrincipalChange = invalidateSessionOnPrincipalChange;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setRequiresAuthenticationRequestMatcher(RequestMatcher requiresAuthenticationRequestMatcher) {
        Assert.notNull((Object)requiresAuthenticationRequestMatcher, "requestMatcher cannot be null");
        this.requiresAuthenticationRequestMatcher = requiresAuthenticationRequestMatcher;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    protected abstract Object getPreAuthenticatedPrincipal(HttpServletRequest var1);

    protected abstract Object getPreAuthenticatedCredentials(HttpServletRequest var1);

    private class PreAuthenticatedProcessingRequestMatcher
    implements RequestMatcher {
        private PreAuthenticatedProcessingRequestMatcher() {
        }

        @Override
        public boolean matches(HttpServletRequest request2) {
            Authentication currentUser = AbstractPreAuthenticatedProcessingFilter.this.securityContextHolderStrategy.getContext().getAuthentication();
            if (currentUser == null) {
                return true;
            }
            if (!AbstractPreAuthenticatedProcessingFilter.this.checkForPrincipalChanges) {
                return false;
            }
            if (!AbstractPreAuthenticatedProcessingFilter.this.principalChanged(request2, currentUser)) {
                return false;
            }
            AbstractPreAuthenticatedProcessingFilter.this.logger.debug("Pre-authenticated principal has changed and will be reauthenticated");
            if (AbstractPreAuthenticatedProcessingFilter.this.invalidateSessionOnPrincipalChange) {
                AbstractPreAuthenticatedProcessingFilter.this.securityContextHolderStrategy.clearContext();
                HttpSession session = request2.getSession(false);
                if (session != null) {
                    AbstractPreAuthenticatedProcessingFilter.this.logger.debug("Invalidating existing session");
                    session.invalidate();
                    request2.getSession();
                }
            }
            return true;
        }
    }
}

