/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.x509;

import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509AuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private X509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();

    @Override
    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request2) {
        X509Certificate cert = this.extractClientCertificate(request2);
        return cert != null ? this.principalExtractor.extractPrincipal(cert) : null;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest request2) {
        return this.extractClientCertificate(request2);
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request2) {
        X509Certificate[] certs = (X509Certificate[])request2.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            this.logger.debug(LogMessage.format("X.509 client authentication certificate:%s", (Object)certs[0]));
            return certs[0];
        }
        this.logger.debug("No client certificate found in request.");
        return null;
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }
}

