/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractRememberMeServices
implements RememberMeServices,
InitializingBean,
LogoutHandler,
MessageSourceAware {
    public static final String SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY = "remember-me";
    public static final String DEFAULT_PARAMETER = "remember-me";
    public static final int TWO_WEEKS_S = 1209600;
    private static final String DELIMITER = ":";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private String cookieName = "remember-me";
    private String cookieDomain;
    private String parameter = "remember-me";
    private boolean alwaysRemember;
    private String key;
    private int tokenValiditySeconds = 1209600;
    private Boolean useSecureCookie = null;
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    protected AbstractRememberMeServices(String key, UserDetailsService userDetailsService) {
        Assert.hasLength(key, "key cannot be empty or null");
        Assert.notNull((Object)userDetailsService, "UserDetailsService cannot be null");
        this.key = key;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.hasLength(this.key, "key cannot be empty or null");
        Assert.notNull((Object)this.userDetailsService, "A UserDetailsService is required");
    }

    @Override
    public final Authentication autoLogin(HttpServletRequest request2, HttpServletResponse response) {
        String rememberMeCookie = this.extractRememberMeCookie(request2);
        if (rememberMeCookie == null) {
            return null;
        }
        this.logger.debug("Remember-me cookie detected");
        if (rememberMeCookie.length() == 0) {
            this.logger.debug("Cookie was empty");
            this.cancelCookie(request2, response);
            return null;
        }
        try {
            String[] cookieTokens = this.decodeCookie(rememberMeCookie);
            UserDetails user = this.processAutoLoginCookie(cookieTokens, request2, response);
            this.userDetailsChecker.check(user);
            this.logger.debug("Remember-me cookie accepted");
            return this.createSuccessfulAuthentication(request2, user);
        }
        catch (CookieTheftException ex) {
            this.cancelCookie(request2, response);
            throw ex;
        }
        catch (UsernameNotFoundException ex) {
            this.logger.debug("Remember-me login was valid but corresponding user not found.", ex);
        }
        catch (InvalidCookieException ex) {
            this.logger.debug("Invalid remember-me cookie: " + ex.getMessage());
        }
        catch (AccountStatusException ex) {
            this.logger.debug("Invalid UserDetails: " + ex.getMessage());
        }
        catch (RememberMeAuthenticationException ex) {
            this.logger.debug(ex.getMessage());
        }
        this.cancelCookie(request2, response);
        return null;
    }

    protected String extractRememberMeCookie(HttpServletRequest request2) {
        Cookie[] cookies = request2.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected Authentication createSuccessfulAuthentication(HttpServletRequest request2, UserDetails user) {
        RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.key, (Object)user, this.authoritiesMapper.mapAuthorities(user.getAuthorities()));
        auth.setDetails(this.authenticationDetailsSource.buildDetails(request2));
        return auth;
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        String cookieAsPlainText;
        for (int j = 0; j < ((String)cookieValue).length() % 4; ++j) {
            cookieValue = (String)cookieValue + "=";
        }
        try {
            cookieAsPlainText = new String(Base64.getDecoder().decode(((String)cookieValue).getBytes()));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidCookieException("Cookie token was not Base64 encoded; value was '" + (String)cookieValue + "'");
        }
        String[] tokens = StringUtils.delimitedListToStringArray(cookieAsPlainText, DELIMITER);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            try {
                tokens[i2] = URLDecoder.decode(tokens[i2], StandardCharsets.UTF_8.toString());
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error(ex.getMessage(), ex);
            }
        }
        return tokens;
    }

    protected String encodeCookie(String[] cookieTokens) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < cookieTokens.length; ++i2) {
            try {
                sb.append(URLEncoder.encode(cookieTokens[i2], StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error(ex.getMessage(), ex);
            }
            if (i2 >= cookieTokens.length - 1) continue;
            sb.append(DELIMITER);
        }
        String value = sb.toString();
        sb = new StringBuilder(new String(Base64.getEncoder().encode(value.getBytes())));
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public final void loginFail(HttpServletRequest request2, HttpServletResponse response) {
        this.logger.debug("Interactive login attempt was unsuccessful.");
        this.cancelCookie(request2, response);
        this.onLoginFail(request2, response);
    }

    protected void onLoginFail(HttpServletRequest request2, HttpServletResponse response) {
    }

    @Override
    public final void loginSuccess(HttpServletRequest request2, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!this.rememberMeRequested(request2, this.parameter)) {
            this.logger.debug("Remember-me login not requested.");
            return;
        }
        this.onLoginSuccess(request2, response, successfulAuthentication);
    }

    protected abstract void onLoginSuccess(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    protected boolean rememberMeRequested(HttpServletRequest request2, String parameter) {
        if (this.alwaysRemember) {
            return true;
        }
        String paramValue = request2.getParameter(parameter);
        if (paramValue != null && (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("on") || paramValue.equalsIgnoreCase("yes") || paramValue.equals("1"))) {
            return true;
        }
        this.logger.debug(LogMessage.format("Did not send remember-me cookie (principal did not set parameter '%s')", (Object)parameter));
        return false;
    }

    protected abstract UserDetails processAutoLoginCookie(String[] var1, HttpServletRequest var2, HttpServletResponse var3) throws RememberMeAuthenticationException, UsernameNotFoundException;

    protected void cancelCookie(HttpServletRequest request2, HttpServletResponse response) {
        this.logger.debug("Cancelling cookie");
        Cookie cookie = new Cookie(this.cookieName, null);
        cookie.setMaxAge(0);
        cookie.setPath(this.getCookiePath(request2));
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setSecure(this.useSecureCookie != null ? this.useSecureCookie.booleanValue() : request2.isSecure());
        response.addCookie(cookie);
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request2, HttpServletResponse response) {
        String cookieValue = this.encodeCookie(tokens);
        Cookie cookie = new Cookie(this.cookieName, cookieValue);
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.getCookiePath(request2));
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        if (maxAge < 1) {
            cookie.setVersion(1);
        }
        cookie.setSecure(this.useSecureCookie != null ? this.useSecureCookie.booleanValue() : request2.isSecure());
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    private String getCookiePath(HttpServletRequest request2) {
        String contextPath = request2.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    @Override
    public void logout(HttpServletRequest request2, HttpServletResponse response, Authentication authentication) {
        this.logger.debug(LogMessage.of(() -> "Logout of user " + (authentication != null ? authentication.getName() : "Unknown")));
        this.cancelCookie(request2, response);
    }

    public void setCookieName(String cookieName) {
        Assert.hasLength(cookieName, "Cookie name cannot be empty or null");
        this.cookieName = cookieName;
    }

    public void setCookieDomain(String cookieDomain) {
        Assert.hasLength(cookieDomain, "Cookie domain cannot be empty or null");
        this.cookieDomain = cookieDomain;
    }

    protected String getCookieName() {
        return this.cookieName;
    }

    public void setAlwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
    }

    public void setParameter(String parameter) {
        Assert.hasText(parameter, "Parameter name cannot be empty or null");
        this.parameter = parameter;
    }

    public String getParameter() {
        return this.parameter;
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public String getKey() {
        return this.key;
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    protected int getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    public void setUseSecureCookie(boolean useSecureCookie) {
        this.useSecureCookie = useSecureCookie;
    }

    protected AuthenticationDetailsSource<HttpServletRequest, ?> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, "AuthenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, "messageSource cannot be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }
}

