/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;

public final class DelegatingSecurityContextRepository
implements SecurityContextRepository {
    private final List<SecurityContextRepository> delegates;

    public DelegatingSecurityContextRepository(SecurityContextRepository ... delegates) {
        this(Arrays.asList(delegates));
    }

    public DelegatingSecurityContextRepository(List<SecurityContextRepository> delegates) {
        Assert.notEmpty(delegates, "delegates cannot be empty");
        this.delegates = delegates;
    }

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        return (SecurityContext)this.loadDeferredContext(requestResponseHolder.getRequest()).get();
    }

    @Override
    public DeferredSecurityContext loadDeferredContext(HttpServletRequest request2) {
        DeferredSecurityContext deferredSecurityContext = null;
        for (SecurityContextRepository delegate : this.delegates) {
            if (deferredSecurityContext == null) {
                deferredSecurityContext = delegate.loadDeferredContext(request2);
                continue;
            }
            DeferredSecurityContext next = delegate.loadDeferredContext(request2);
            deferredSecurityContext = new DelegatingDeferredSecurityContext(deferredSecurityContext, next);
        }
        return deferredSecurityContext;
    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request2, HttpServletResponse response) {
        for (SecurityContextRepository delegate : this.delegates) {
            delegate.saveContext(context, request2, response);
        }
    }

    @Override
    public boolean containsContext(HttpServletRequest request2) {
        for (SecurityContextRepository delegate : this.delegates) {
            if (!delegate.containsContext(request2)) continue;
            return true;
        }
        return false;
    }

    static final class DelegatingDeferredSecurityContext
    implements DeferredSecurityContext {
        private final DeferredSecurityContext previous;
        private final DeferredSecurityContext next;

        DelegatingDeferredSecurityContext(DeferredSecurityContext previous, DeferredSecurityContext next) {
            this.previous = previous;
            this.next = next;
        }

        @Override
        public SecurityContext get() {
            SecurityContext securityContext = (SecurityContext)this.previous.get();
            if (!this.previous.isGenerated()) {
                return securityContext;
            }
            return (SecurityContext)this.next.get();
        }

        @Override
        public boolean isGenerated() {
            return this.previous.isGenerated() && this.next.isGenerated();
        }
    }
}

