/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.util.Assert;

public class CsrfTokenRequestAttributeHandler
implements CsrfTokenRequestHandler {
    private String csrfRequestAttributeName = "_csrf";

    public final void setCsrfRequestAttributeName(String csrfRequestAttributeName) {
        this.csrfRequestAttributeName = csrfRequestAttributeName;
    }

    @Override
    public void handle(HttpServletRequest request2, HttpServletResponse response, Supplier<CsrfToken> deferredCsrfToken) {
        Assert.notNull((Object)request2, "request cannot be null");
        Assert.notNull((Object)response, "response cannot be null");
        Assert.notNull(deferredCsrfToken, "deferredCsrfToken cannot be null");
        request2.setAttribute(HttpServletResponse.class.getName(), response);
        SupplierCsrfToken csrfToken = new SupplierCsrfToken(deferredCsrfToken);
        request2.setAttribute(CsrfToken.class.getName(), csrfToken);
        String csrfAttrName = this.csrfRequestAttributeName != null ? this.csrfRequestAttributeName : csrfToken.getParameterName();
        request2.setAttribute(csrfAttrName, csrfToken);
    }

    private static final class SupplierCsrfToken
    implements CsrfToken {
        private final Supplier<CsrfToken> csrfTokenSupplier;

        private SupplierCsrfToken(Supplier<CsrfToken> csrfTokenSupplier) {
            this.csrfTokenSupplier = csrfTokenSupplier;
        }

        @Override
        public String getHeaderName() {
            return this.getDelegate().getHeaderName();
        }

        @Override
        public String getParameterName() {
            return this.getDelegate().getParameterName();
        }

        @Override
        public String getToken() {
            return this.getDelegate().getToken();
        }

        private CsrfToken getDelegate() {
            CsrfToken delegate = this.csrfTokenSupplier.get();
            if (delegate == null) {
                throw new IllegalStateException("csrfTokenSupplier returned null delegate");
            }
            return delegate;
        }
    }
}

