/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.debug;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.debug.Logger;
import org.springframework.security.web.util.UrlUtils;

public final class DebugFilter
implements Filter {
    static final String ALREADY_FILTERED_ATTR_NAME = DebugFilter.class.getName().concat(".FILTERED");
    private final FilterChainProxy filterChainProxy;
    private final Logger logger = new Logger();

    public DebugFilter(FilterChainProxy filterChainProxy) {
        this.filterChainProxy = filterChainProxy;
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request2 instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("DebugFilter just supports HTTP requests");
        }
        this.doFilter((HttpServletRequest)request2, (HttpServletResponse)response, filterChain);
    }

    private void doFilter(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        List<Filter> filters = this.getFilters(request2);
        this.logger.info("Request received for " + request2.getMethod() + " '" + UrlUtils.buildRequestUrl(request2) + "':\n\n" + request2 + "\n\nservletPath:" + request2.getServletPath() + "\npathInfo:" + request2.getPathInfo() + "\nheaders: \n" + this.formatHeaders(request2) + "\n\n" + this.formatFilters(filters));
        if (request2.getAttribute(ALREADY_FILTERED_ATTR_NAME) == null) {
            this.invokeWithWrappedRequest(request2, response, filterChain);
        } else {
            this.filterChainProxy.doFilter(request2, response, filterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeWithWrappedRequest(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request2.setAttribute(ALREADY_FILTERED_ATTR_NAME, Boolean.TRUE);
        request2 = new DebugRequestWrapper(request2);
        try {
            this.filterChainProxy.doFilter(request2, response, filterChain);
        }
        finally {
            request2.removeAttribute(ALREADY_FILTERED_ATTR_NAME);
        }
    }

    String formatHeaders(HttpServletRequest request2) {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> eHeaderNames = request2.getHeaderNames();
        while (eHeaderNames.hasMoreElements()) {
            String headerName = eHeaderNames.nextElement();
            sb.append(headerName);
            sb.append(": ");
            Enumeration<String> eHeaderValues = request2.getHeaders(headerName);
            while (eHeaderValues.hasMoreElements()) {
                sb.append(eHeaderValues.nextElement());
                if (!eHeaderValues.hasMoreElements()) continue;
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    String formatFilters(List<Filter> filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("Security filter chain: ");
        if (filters == null) {
            sb.append("no match");
        } else if (filters.isEmpty()) {
            sb.append("[] empty (bypassed by security='none') ");
        } else {
            sb.append("[\n");
            for (Filter f : filters) {
                sb.append("  ").append(f.getClass().getSimpleName()).append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private List<Filter> getFilters(HttpServletRequest request2) {
        for (SecurityFilterChain chain : this.filterChainProxy.getFilterChains()) {
            if (!chain.matches(request2)) continue;
            return chain.getFilters();
        }
        return null;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    public FilterChainProxy getFilterChainProxy() {
        return this.filterChainProxy;
    }

    static class DebugRequestWrapper
    extends HttpServletRequestWrapper {
        private static final Logger logger = new Logger();

        DebugRequestWrapper(HttpServletRequest request2) {
            super(request2);
        }

        @Override
        public HttpSession getSession() {
            boolean sessionExists = super.getSession(false) != null;
            HttpSession session = super.getSession();
            if (!sessionExists) {
                logger.info("New HTTP session created: " + session.getId(), true);
            }
            return session;
        }

        @Override
        public HttpSession getSession(boolean create) {
            if (!create) {
                return super.getSession(create);
            }
            return this.getSession();
        }
    }
}

