/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.savedrequest.SavedRequestAwareWrapper;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.WebUtils;

public class CookieRequestCache
implements RequestCache {
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String COOKIE_NAME = "REDIRECT_URI";
    private static final int COOKIE_MAX_AGE = -1;

    @Override
    public void saveRequest(HttpServletRequest request2, HttpServletResponse response) {
        if (!this.requestMatcher.matches(request2)) {
            this.logger.debug("Request not saved as configured RequestMatcher did not match");
            return;
        }
        String redirectUrl = UrlUtils.buildFullRequestUrl(request2);
        Cookie savedCookie = new Cookie(COOKIE_NAME, CookieRequestCache.encodeCookie(redirectUrl));
        savedCookie.setMaxAge(-1);
        savedCookie.setSecure(request2.isSecure());
        savedCookie.setPath(CookieRequestCache.getCookiePath(request2));
        savedCookie.setHttpOnly(true);
        response.addCookie(savedCookie);
    }

    @Override
    public SavedRequest getRequest(HttpServletRequest request2, HttpServletResponse response) {
        Cookie savedRequestCookie = WebUtils.getCookie(request2, COOKIE_NAME);
        if (savedRequestCookie == null) {
            return null;
        }
        String originalURI = CookieRequestCache.decodeCookie(savedRequestCookie.getValue());
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(originalURI).build();
        DefaultSavedRequest.Builder builder = new DefaultSavedRequest.Builder();
        int port = this.getPort(uriComponents);
        return builder.setScheme(uriComponents.getScheme()).setServerName(uriComponents.getHost()).setRequestURI(uriComponents.getPath()).setQueryString(uriComponents.getQuery()).setServerPort(port).setMethod(request2.getMethod()).build();
    }

    private int getPort(UriComponents uriComponents) {
        int port = uriComponents.getPort();
        if (port != -1) {
            return port;
        }
        if ("https".equalsIgnoreCase(uriComponents.getScheme())) {
            return 443;
        }
        return 80;
    }

    @Override
    public HttpServletRequest getMatchingRequest(HttpServletRequest request2, HttpServletResponse response) {
        SavedRequest saved = this.getRequest(request2, response);
        if (!this.matchesSavedRequest(request2, saved)) {
            this.logger.debug("saved request doesn't match");
            return null;
        }
        this.removeRequest(request2, response);
        return new SavedRequestAwareWrapper(saved, request2);
    }

    @Override
    public void removeRequest(HttpServletRequest request2, HttpServletResponse response) {
        Cookie removeSavedRequestCookie = new Cookie(COOKIE_NAME, "");
        removeSavedRequestCookie.setSecure(request2.isSecure());
        removeSavedRequestCookie.setHttpOnly(true);
        removeSavedRequestCookie.setPath(CookieRequestCache.getCookiePath(request2));
        removeSavedRequestCookie.setMaxAge(0);
        response.addCookie(removeSavedRequestCookie);
    }

    private static String encodeCookie(String cookieValue) {
        return Base64.getEncoder().encodeToString(cookieValue.getBytes());
    }

    private static String decodeCookie(String encodedCookieValue) {
        return new String(Base64.getDecoder().decode(encodedCookieValue.getBytes()));
    }

    private static String getCookiePath(HttpServletRequest request2) {
        String contextPath = request2.getContextPath();
        return !StringUtils.isEmpty(contextPath) ? contextPath : "/";
    }

    private boolean matchesSavedRequest(HttpServletRequest request2, SavedRequest savedRequest) {
        if (savedRequest == null) {
            return false;
        }
        String currentUrl = UrlUtils.buildFullRequestUrl(request2);
        return savedRequest.getRedirectUrl().equals(currentUrl);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, "requestMatcher should not be null");
        this.requestMatcher = requestMatcher;
    }
}

