/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.Assert;

public class SimpleSavedRequest
implements SavedRequest {
    private String redirectUrl;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private String method = "GET";
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private List<Locale> locales = new ArrayList<Locale>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();

    public SimpleSavedRequest() {
    }

    public SimpleSavedRequest(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public SimpleSavedRequest(SavedRequest request2) {
        this.redirectUrl = request2.getRedirectUrl();
        this.cookies = request2.getCookies();
        for (String headerName : request2.getHeaderNames()) {
            this.headers.put(headerName, request2.getHeaderValues(headerName));
        }
        this.locales = request2.getLocales();
        this.parameters = request2.getParameterMap();
        this.method = request2.getMethod();
    }

    @Override
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<String> getHeaderValues(String name) {
        return this.headers.getOrDefault(name, new ArrayList());
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.getOrDefault(name, new String[0]);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public void setRedirectUrl(String redirectUrl) {
        Assert.notNull((Object)redirectUrl, "redirectUrl cannot be null");
        this.redirectUrl = redirectUrl;
    }

    public void setCookies(List<Cookie> cookies) {
        Assert.notNull(cookies, "cookies cannot be null");
        this.cookies = cookies;
    }

    public void setMethod(String method) {
        Assert.notNull((Object)method, "method cannot be null");
        this.method = method;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        Assert.notNull(headers, "headers cannot be null");
        this.headers = headers;
    }

    public void setLocales(List<Locale> locales) {
        Assert.notNull("locales cannot be null");
        this.locales = locales;
    }

    public void setParameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, "parameters cannot be null");
        this.parameters = parameters;
    }
}

