/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.context.support.SecurityWebApplicationContextUtils;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.security.web.session.HttpSessionIdChangedEvent;

public class HttpSessionEventPublisher
implements HttpSessionListener,
HttpSessionIdListener {
    private static final String LOGGER_NAME = HttpSessionEventPublisher.class.getName();

    ApplicationContext getContext(ServletContext servletContext) {
        return SecurityWebApplicationContextUtils.findRequiredWebApplicationContext(servletContext);
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        this.extracted(event.getSession(), new HttpSessionCreatedEvent(event.getSession()));
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        this.extracted(event.getSession(), new HttpSessionDestroyedEvent(event.getSession()));
    }

    @Override
    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        this.extracted(event.getSession(), new HttpSessionIdChangedEvent(event.getSession(), oldSessionId));
    }

    private void extracted(HttpSession session, ApplicationEvent e) {
        Log log = LogFactory.getLog(LOGGER_NAME);
        log.debug(LogMessage.format("Publishing event: %s", (Object)e));
        this.getContext(session.getServletContext()).publishEvent(e);
    }
}

