/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.aot.AotContextLoader;
import org.springframework.util.Assert;

public abstract class AbstractDelegatingSmartContextLoader
implements AotContextLoader {
    private static final Log logger = LogFactory.getLog(AbstractDelegatingSmartContextLoader.class);

    protected abstract SmartContextLoader getXmlLoader();

    protected abstract SmartContextLoader getAnnotationConfigLoader();

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        Assert.notNull((Object)configAttributes, "configAttributes must not be null");
        Assert.isTrue(!configAttributes.hasLocations() || !configAttributes.hasClasses(), () -> String.format("Cannot process locations AND classes for context configuration %s: configure one or the other, but not both.", configAttributes));
        if (configAttributes.hasLocations()) {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getXmlLoader(), configAttributes);
        } else if (configAttributes.hasClasses()) {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getAnnotationConfigLoader(), configAttributes);
        } else {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getXmlLoader(), configAttributes);
            boolean xmlLoaderDetectedDefaults = configAttributes.hasLocations();
            if (xmlLoaderDetectedDefaults && logger.isTraceEnabled()) {
                logger.trace(String.format("%s detected default locations for context configuration %s", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), configAttributes));
            }
            Assert.state(!configAttributes.hasClasses(), () -> String.format("%s should NOT have detected default configuration classes for context configuration %s", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), configAttributes));
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getAnnotationConfigLoader(), configAttributes);
            if (configAttributes.hasClasses() && logger.isTraceEnabled()) {
                logger.trace(String.format("%s detected default configuration classes for context configuration %s", AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), configAttributes));
            }
            Assert.state(xmlLoaderDetectedDefaults || !configAttributes.hasLocations(), () -> String.format("%s should NOT have detected default locations for context configuration %s", AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), configAttributes));
            if (configAttributes.hasLocations() && configAttributes.hasClasses()) {
                String msg = String.format("Configuration error: both default locations AND default configuration classes were detected for context configuration %s; configure one or the other, but not both.", configAttributes);
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public final ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        SmartContextLoader loader = this.getContextLoader(mergedConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("Delegating to %s to load context for %s".formatted(AbstractDelegatingSmartContextLoader.name(loader), mergedConfig));
        }
        return loader.loadContext(mergedConfig);
    }

    @Override
    public final ApplicationContext loadContextForAotProcessing(MergedContextConfiguration mergedConfig) throws Exception {
        AotContextLoader loader = this.getAotContextLoader(mergedConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("Delegating to %s to load context for AOT processing for %s".formatted(AbstractDelegatingSmartContextLoader.name(loader), mergedConfig));
        }
        return loader.loadContextForAotProcessing(mergedConfig);
    }

    @Override
    public final ApplicationContext loadContextForAotRuntime(MergedContextConfiguration mergedConfig, ApplicationContextInitializer<ConfigurableApplicationContext> initializer) throws Exception {
        AotContextLoader loader = this.getAotContextLoader(mergedConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("Delegating to %s to load context for AOT execution for %s".formatted(AbstractDelegatingSmartContextLoader.name(loader), mergedConfig));
        }
        return loader.loadContextForAotRuntime(mergedConfig, initializer);
    }

    private SmartContextLoader getContextLoader(MergedContextConfiguration mergedConfig) {
        SmartContextLoader[] candidates;
        Assert.notNull((Object)mergedConfig, "MergedContextConfiguration must not be null");
        Assert.state(!mergedConfig.hasLocations() || !mergedConfig.hasClasses(), () -> "Neither %s nor %s is able to load an ApplicationContext for %s: declare either 'locations' or 'classes' but not both.".formatted(AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), mergedConfig));
        for (SmartContextLoader loader : candidates = new SmartContextLoader[]{this.getXmlLoader(), this.getAnnotationConfigLoader()}) {
            if (!this.supports(loader, mergedConfig)) continue;
            return loader;
        }
        if (AbstractDelegatingSmartContextLoader.hasInitializersOrCustomizers(mergedConfig)) {
            return this.getAnnotationConfigLoader();
        }
        throw new IllegalStateException("Neither %s nor %s is able to load an ApplicationContext for %s.".formatted(AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), mergedConfig));
    }

    private AotContextLoader getAotContextLoader(MergedContextConfiguration mergedConfig) {
        SmartContextLoader loader = this.getContextLoader(mergedConfig);
        if (!(loader instanceof AotContextLoader)) {
            throw new IllegalStateException("%s must be an AotContextLoader".formatted(AbstractDelegatingSmartContextLoader.name(loader)));
        }
        AotContextLoader aotContextLoader = (AotContextLoader)loader;
        return aotContextLoader;
    }

    private boolean supports(SmartContextLoader loader, MergedContextConfiguration mergedConfig) {
        if (loader == this.getAnnotationConfigLoader()) {
            return mergedConfig.hasClasses() && !mergedConfig.hasLocations();
        }
        return mergedConfig.hasLocations() && !mergedConfig.hasClasses();
    }

    private static void delegateProcessing(SmartContextLoader loader, ContextConfigurationAttributes configAttributes) {
        if (logger.isTraceEnabled()) {
            logger.trace("Delegating to %s to process context configuration %s".formatted(AbstractDelegatingSmartContextLoader.name(loader), configAttributes));
        }
        loader.processContextConfiguration(configAttributes);
    }

    private static boolean hasInitializersOrCustomizers(MergedContextConfiguration mergedConfig) {
        return !mergedConfig.getContextInitializerClasses().isEmpty() || !mergedConfig.getContextCustomizers().isEmpty();
    }

    private static String name(SmartContextLoader loader) {
        return loader.getClass().getSimpleName();
    }
}

