/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelectors;

public class XmlExpectationsHelper {
    public void assertNode(String content, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat("Body content", document, matcher);
    }

    private Document parseXmlString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        return documentBuilder.parse(inputSource);
    }

    public void assertSource(String content, Matcher<? super Source> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat("Body content", new DOMSource(document), matcher);
    }

    public void assertXmlEqual(String expected, String actual) throws Exception {
        XmlUnitDiff diff = new XmlUnitDiff(expected, actual);
        if (diff.hasDifferences()) {
            AssertionErrors.fail("Body content " + diff);
        }
    }

    private static class XmlUnitDiff {
        private final Diff diff;

        XmlUnitDiff(String expected, String actual) {
            this.diff = DiffBuilder.compare(expected).withTest(actual).withNodeMatcher(new DefaultNodeMatcher(ElementSelectors.byNameAndText)).ignoreWhitespace().ignoreComments().checkForSimilar().build();
        }

        public boolean hasDifferences() {
            return this.diff.hasDifferences();
        }

        public String toString() {
            return this.diff.toString();
        }
    }
}

