/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.Mergeable;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.TestDispatcherServlet;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;

public final class MockMvc {
    static final String MVC_RESULT_ATTRIBUTE = MockMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final TestDispatcherServlet servlet;
    private final Filter[] filters;
    private final ServletContext servletContext;
    @Nullable
    private RequestBuilder defaultRequestBuilder;
    @Nullable
    private Charset defaultResponseCharacterEncoding;
    private List<ResultMatcher> defaultResultMatchers = new ArrayList<ResultMatcher>();
    private List<ResultHandler> defaultResultHandlers = new ArrayList<ResultHandler>();

    MockMvc(TestDispatcherServlet servlet, Filter ... filters) {
        Assert.notNull((Object)servlet, "DispatcherServlet is required");
        Assert.notNull((Object)filters, "Filters cannot be null");
        Assert.noNullElements((Object[])filters, "Filters cannot contain null values");
        this.servlet = servlet;
        this.filters = filters;
        this.servletContext = servlet.getServletContext();
    }

    void setDefaultRequest(@Nullable RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
    }

    void setDefaultResponseCharacterEncoding(@Nullable Charset defaultResponseCharacterEncoding) {
        this.defaultResponseCharacterEncoding = defaultResponseCharacterEncoding;
    }

    void setGlobalResultMatchers(List<ResultMatcher> resultMatchers) {
        Assert.notNull(resultMatchers, "ResultMatcher List is required");
        this.defaultResultMatchers = resultMatchers;
    }

    void setGlobalResultHandlers(List<ResultHandler> resultHandlers) {
        Assert.notNull(resultHandlers, "ResultHandler List is required");
        this.defaultResultHandlers = resultHandlers;
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.servlet;
    }

    public ResultActions perform(RequestBuilder requestBuilder) throws Exception {
        MockHttpServletResponse mockResponse;
        HttpServletResponse servletResponse;
        MockHttpServletRequest request2;
        AsyncContext asyncContext;
        if (this.defaultRequestBuilder != null && requestBuilder instanceof Mergeable) {
            Mergeable mergeable = (Mergeable)((Object)requestBuilder);
            requestBuilder = (RequestBuilder)mergeable.merge(this.defaultRequestBuilder);
        }
        if ((asyncContext = (request2 = requestBuilder.buildRequest(this.servletContext)).getAsyncContext()) != null) {
            servletResponse = (HttpServletResponse)asyncContext.getResponse();
            mockResponse = this.unwrapResponseIfNecessary(servletResponse);
        } else {
            mockResponse = new MockHttpServletResponse();
            servletResponse = mockResponse;
        }
        if (this.defaultResponseCharacterEncoding != null) {
            mockResponse.setDefaultCharacterEncoding(this.defaultResponseCharacterEncoding.name());
        }
        if (requestBuilder instanceof SmartRequestBuilder) {
            SmartRequestBuilder smartRequestBuilder = (SmartRequestBuilder)requestBuilder;
            request2 = smartRequestBuilder.postProcessRequest(request2);
        }
        final DefaultMvcResult mvcResult = new DefaultMvcResult(request2, mockResponse);
        request2.setAttribute(MVC_RESULT_ATTRIBUTE, mvcResult);
        RequestAttributes previousAttributes = RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes(new ServletRequestAttributes(request2, servletResponse));
        MockFilterChain filterChain = new MockFilterChain(this.servlet, this.filters);
        filterChain.doFilter(request2, servletResponse);
        if (DispatcherType.ASYNC.equals((Object)request2.getDispatcherType()) && asyncContext != null && !request2.isAsyncStarted()) {
            asyncContext.complete();
        }
        this.applyDefaultResultActions(mvcResult);
        RequestContextHolder.setRequestAttributes(previousAttributes);
        return new ResultActions(){

            @Override
            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match(mvcResult);
                return this;
            }

            @Override
            public ResultActions andDo(ResultHandler handler) throws Exception {
                handler.handle(mvcResult);
                return this;
            }

            @Override
            public MvcResult andReturn() {
                return mvcResult;
            }
        };
    }

    private MockHttpServletResponse unwrapResponseIfNecessary(ServletResponse servletResponse) {
        while (servletResponse instanceof HttpServletResponseWrapper) {
            HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)servletResponse;
            servletResponse = wrapper.getResponse();
        }
        Assert.isInstanceOf(MockHttpServletResponse.class, servletResponse);
        return (MockHttpServletResponse)servletResponse;
    }

    private void applyDefaultResultActions(MvcResult mvcResult) throws Exception {
        for (ResultHandler handler : this.defaultResultHandlers) {
            handler.handle(mvcResult);
        }
        for (ResultMatcher matcher : this.defaultResultMatchers) {
            matcher.match(mvcResult);
        }
    }
}

