/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.ErrorResponse;

public class MethodArgumentNotValidException
extends BindException
implements ErrorResponse {
    private final MethodParameter parameter;
    private final ProblemDetail body;

    public MethodArgumentNotValidException(MethodParameter parameter, BindingResult bindingResult) {
        super(bindingResult);
        this.parameter = parameter;
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), "Invalid request content.");
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed for argument [").append(this.parameter.getParameterIndex()).append("] in ").append(this.parameter.getExecutable().toGenericString());
        BindingResult bindingResult = this.getBindingResult();
        if (bindingResult.getErrorCount() > 1) {
            sb.append(" with ").append(bindingResult.getErrorCount()).append(" errors");
        }
        sb.append(": ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append('[').append(error).append("] ");
        }
        return sb.toString();
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{MethodArgumentNotValidException.errorsToStringList(this.getGlobalErrors()), MethodArgumentNotValidException.errorsToStringList(this.getFieldErrors())};
    }

    @Override
    public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return new Object[]{MethodArgumentNotValidException.errorsToStringList(this.getGlobalErrors(), messageSource, locale), MethodArgumentNotValidException.errorsToStringList(this.getFieldErrors(), messageSource, locale)};
    }

    public Map<ObjectError, String> resolveErrorMessages(MessageSource messageSource, Locale locale) {
        LinkedHashMap<ObjectError, String> map = new LinkedHashMap<ObjectError, String>();
        MethodArgumentNotValidException.addMessages(map, this.getGlobalErrors(), messageSource, locale);
        MethodArgumentNotValidException.addMessages(map, this.getFieldErrors(), messageSource, locale);
        return map;
    }

    private static void addMessages(Map<ObjectError, String> map, List<? extends ObjectError> errors, MessageSource messageSource, Locale locale) {
        List<String> messages = MethodArgumentNotValidException.errorsToStringList(errors, messageSource, locale);
        for (int i2 = 0; i2 < errors.size(); ++i2) {
            map.put(errors.get(i2), messages.get(i2));
        }
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors) {
        return MethodArgumentNotValidException.errorsToStringList(errors, error -> error.getDefaultMessage() != null ? error.getDefaultMessage() : error.getCode());
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors, @Nullable MessageSource source, Locale locale) {
        return source != null ? MethodArgumentNotValidException.errorsToStringList(errors, error -> source.getMessage((MessageSourceResolvable)error, locale)) : MethodArgumentNotValidException.errorsToStringList(errors);
    }

    private static List<String> errorsToStringList(List<? extends ObjectError> errors, Function<ObjectError, String> formatter) {
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (ObjectError objectError : errors) {
            String string;
            String value = formatter.apply(objectError);
            if (!StringUtils.hasText(value)) continue;
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                string = fieldError.getField() + ": '" + value + "'";
            } else {
                string = "'" + value + "'";
            }
            result.add(string);
        }
        return result;
    }
}

