/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.context.request.WebRequest;

public class DefaultSessionAttributeStore
implements SessionAttributeStore {
    private String attributeNamePrefix = "";

    public void setAttributeNamePrefix(@Nullable String attributeNamePrefix) {
        this.attributeNamePrefix = attributeNamePrefix != null ? attributeNamePrefix : "";
    }

    @Override
    public void storeAttribute(WebRequest request2, String attributeName, Object attributeValue) {
        Assert.notNull((Object)request2, "WebRequest must not be null");
        Assert.notNull((Object)attributeName, "Attribute name must not be null");
        Assert.notNull(attributeValue, "Attribute value must not be null");
        String storeAttributeName = this.getAttributeNameInSession(request2, attributeName);
        request2.setAttribute(storeAttributeName, attributeValue, 1);
    }

    @Override
    @Nullable
    public Object retrieveAttribute(WebRequest request2, String attributeName) {
        Assert.notNull((Object)request2, "WebRequest must not be null");
        Assert.notNull((Object)attributeName, "Attribute name must not be null");
        String storeAttributeName = this.getAttributeNameInSession(request2, attributeName);
        return request2.getAttribute(storeAttributeName, 1);
    }

    @Override
    public void cleanupAttribute(WebRequest request2, String attributeName) {
        Assert.notNull((Object)request2, "WebRequest must not be null");
        Assert.notNull((Object)attributeName, "Attribute name must not be null");
        String storeAttributeName = this.getAttributeNameInSession(request2, attributeName);
        request2.removeAttribute(storeAttributeName, 1);
    }

    protected String getAttributeNameInSession(WebRequest request2, String attributeName) {
        return this.attributeNamePrefix + attributeName;
    }
}

