/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public abstract class AbstractNamedValueArgumentResolver
implements HttpServiceArgumentResolver {
    private static final TypeDescriptor STRING_TARGET_TYPE = TypeDescriptor.valueOf(String.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private final ConversionService conversionService;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    protected AbstractNamedValueArgumentResolver(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService is required");
        this.conversionService = conversionService;
    }

    protected AbstractNamedValueArgumentResolver() {
        this.conversionService = null;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        NamedValueInfo info2 = this.getNamedValueInfo(parameter);
        if (info2 == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(parameter.getParameterType())) {
            Assert.isInstanceOf(Map.class, argument);
            parameter = parameter.nested(1);
            argument = argument != null ? argument : Collections.emptyMap();
            for (Map.Entry entry : argument.entrySet()) {
                this.addSingleOrMultipleValues((String)entry.getKey(), entry.getValue(), false, null, info2.label, info2.multiValued, parameter, requestValues);
            }
        } else {
            this.addSingleOrMultipleValues(info2.name, argument, info2.required, info2.defaultValue, info2.label, info2.multiValued, parameter, requestValues);
        }
        return true;
    }

    @Nullable
    private NamedValueInfo getNamedValueInfo(MethodParameter parameter) {
        NamedValueInfo info2 = this.namedValueInfoCache.get(parameter);
        if (info2 == null) {
            info2 = this.createNamedValueInfo(parameter);
            if (info2 == null) {
                return null;
            }
            info2 = this.updateNamedValueInfo(parameter, info2);
            this.namedValueInfoCache.put(parameter, info2);
        }
        return info2;
    }

    @Nullable
    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info2) {
        String name = info2.name;
        if (info2.name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument of type [" + parameter.getParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
        }
        boolean required = info2.required && !parameter.getParameterType().equals(Optional.class);
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info2.defaultValue) ? null : info2.defaultValue;
        return info2.update(name, required, defaultValue);
    }

    private void addSingleOrMultipleValues(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, boolean supportsMultiValues, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (supportsMultiValues) {
            if (ObjectUtils.isArray(value)) {
                value = Arrays.asList((Object[])value);
            }
            if (value instanceof Collection) {
                Collection elements = value;
                parameter = parameter.nested();
                boolean hasValues = false;
                for (Object element : elements) {
                    if (element == null) continue;
                    hasValues = true;
                    this.addSingleValue(name, element, false, null, valueLabel, parameter, requestValues);
                }
                if (hasValues) {
                    return;
                }
                value = null;
            }
        }
        this.addSingleValue(name, value, required, defaultValue, valueLabel, parameter, requestValues);
    }

    private void addSingleValue(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            value = optionalValue.orElse(null);
        }
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (this.conversionService != null && !(value instanceof String)) {
            Class<?> type = (parameter = parameter.nestedIfOptional()).getNestedParameterType();
            Object object = value = type != Object.class && !type.isArray() ? this.conversionService.convert(value, new TypeDescriptor(parameter), STRING_TARGET_TYPE) : this.conversionService.convert(value, String.class);
        }
        if (value == null) {
            Assert.isTrue(!required, () -> "Missing " + valueLabel + " value '" + name + "'");
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Resolved " + valueLabel + " value '" + name + ":" + value + "'");
        }
        this.addRequestValue(name, value, parameter, requestValues);
    }

    protected abstract void addRequestValue(String var1, Object var2, MethodParameter var3, HttpRequestValues.Builder var4);

    protected static class NamedValueInfo {
        private final String name;
        private final boolean required;
        @Nullable
        private final String defaultValue;
        private final String label;
        private final boolean multiValued;

        public NamedValueInfo(String name, boolean required, @Nullable String defaultValue, String label, boolean multiValued) {
            this.name = name;
            this.required = required;
            this.defaultValue = defaultValue;
            this.label = label;
            this.multiValued = multiValued;
        }

        public NamedValueInfo update(String name, boolean required, @Nullable String defaultValue) {
            return new NamedValueInfo(name, required, defaultValue, this.label, this.multiValued);
        }
    }
}

