/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;

public class UserRoleAuthorizationInterceptor
implements HandlerInterceptor {
    @Nullable
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String ... authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    @Override
    public final boolean preHandle(HttpServletRequest request2, HttpServletResponse response, Object handler) throws ServletException, IOException {
        if (this.authorizedRoles != null) {
            for (String role : this.authorizedRoles) {
                if (!request2.isUserInRole(role)) continue;
                return true;
            }
        }
        this.handleNotAuthorized(request2, response, handler);
        return false;
    }

    protected void handleNotAuthorized(HttpServletRequest request2, HttpServletResponse response, Object handler) throws ServletException, IOException {
        response.sendError(403);
    }
}

