/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;
import org.springframework.web.servlet.HandlerMapping;

public class ServletModelAttributeMethodProcessor
extends ModelAttributeMethodProcessor {
    public ServletModelAttributeMethodProcessor(boolean annotationNotRequired) {
        super(annotationNotRequired);
    }

    @Override
    protected final Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request2) throws Exception {
        Object attribute;
        String value = this.getRequestValueForAttribute(attributeName, request2);
        if (value != null && (attribute = this.createAttributeFromRequestValue(value, attributeName, parameter, binderFactory, request2)) != null) {
            return attribute;
        }
        return super.createAttribute(attributeName, parameter, binderFactory, request2);
    }

    @Nullable
    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request2) {
        Map<String, String> variables = this.getUriTemplateVariables(request2);
        String variableValue = variables.get(attributeName);
        if (StringUtils.hasText(variableValue)) {
            return variableValue;
        }
        String parameterValue = request2.getParameter(attributeName);
        if (StringUtils.hasText(parameterValue)) {
            return parameterValue;
        }
        return null;
    }

    protected final Map<String, String> getUriTemplateVariables(NativeWebRequest request2) {
        Map<String, String> variables = (Map<String, String>)request2.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        return variables != null ? variables : Collections.emptyMap();
    }

    @Nullable
    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request2) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request2, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = new TypeDescriptor(parameter))) {
            return binder.convertIfNecessary((Object)sourceValue, parameter.getParameterType(), parameter);
        }
        return null;
    }

    @Override
    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request2) {
        ServletRequest servletRequest = request2.getNativeRequest(ServletRequest.class);
        Assert.state(servletRequest != null, "No ServletRequest");
        ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
        servletBinder.bind(servletRequest);
    }

    @Override
    @Nullable
    public Object resolveConstructorArgument(String paramName, Class<?> paramType, NativeWebRequest request2) throws Exception {
        Object value = super.resolveConstructorArgument(paramName, paramType, request2);
        if (value != null) {
            return value;
        }
        ServletRequest servletRequest = request2.getNativeRequest(ServletRequest.class);
        if (servletRequest != null) {
            String attr = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
            Map uriVars = (Map)servletRequest.getAttribute(attr);
            return uriVars.get(paramName);
        }
        return null;
    }
}

