/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.lang.Nullable;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class RequestContextUtils {
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";

    @Nullable
    public static WebApplicationContext findWebApplicationContext(HttpServletRequest request2, @Nullable ServletContext servletContext) {
        WebApplicationContext webApplicationContext = (WebApplicationContext)request2.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext != null) {
                webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(servletContext);
            }
            if (webApplicationContext == null) {
                webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
            }
        }
        return webApplicationContext;
    }

    @Nullable
    public static WebApplicationContext findWebApplicationContext(HttpServletRequest request2) {
        return RequestContextUtils.findWebApplicationContext(request2, request2.getServletContext());
    }

    @Nullable
    public static LocaleResolver getLocaleResolver(HttpServletRequest request2) {
        return (LocaleResolver)request2.getAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE);
    }

    public static Locale getLocale(HttpServletRequest request2) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request2);
        return localeResolver != null ? localeResolver.resolveLocale(request2) : request2.getLocale();
    }

    @Nullable
    public static TimeZone getTimeZone(HttpServletRequest request2) {
        LocaleContextResolver localeContextResolver;
        LocaleContext localeContext;
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request2);
        if (localeResolver instanceof LocaleContextResolver && (localeContext = (localeContextResolver = (LocaleContextResolver)localeResolver).resolveLocaleContext(request2)) instanceof TimeZoneAwareLocaleContext) {
            TimeZoneAwareLocaleContext timeZoneAwareLocaleContext = (TimeZoneAwareLocaleContext)localeContext;
            return timeZoneAwareLocaleContext.getTimeZone();
        }
        return null;
    }

    @Nullable
    @Deprecated(since="6.0")
    public static ThemeResolver getThemeResolver(HttpServletRequest request2) {
        return (ThemeResolver)request2.getAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE);
    }

    @Nullable
    @Deprecated(since="6.0")
    public static ThemeSource getThemeSource(HttpServletRequest request2) {
        return (ThemeSource)request2.getAttribute(DispatcherServlet.THEME_SOURCE_ATTRIBUTE);
    }

    @Nullable
    @Deprecated(since="6.0")
    public static Theme getTheme(HttpServletRequest request2) {
        ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(request2);
        ThemeSource themeSource = RequestContextUtils.getThemeSource(request2);
        if (themeResolver != null && themeSource != null) {
            String themeName = themeResolver.resolveThemeName(request2);
            return themeSource.getTheme(themeName);
        }
        return null;
    }

    @Nullable
    public static Map<String, ?> getInputFlashMap(HttpServletRequest request2) {
        return (Map)request2.getAttribute(DispatcherServlet.INPUT_FLASH_MAP_ATTRIBUTE);
    }

    public static FlashMap getOutputFlashMap(HttpServletRequest request2) {
        return (FlashMap)request2.getAttribute(DispatcherServlet.OUTPUT_FLASH_MAP_ATTRIBUTE);
    }

    @Nullable
    public static FlashMapManager getFlashMapManager(HttpServletRequest request2) {
        return (FlashMapManager)request2.getAttribute(DispatcherServlet.FLASH_MAP_MANAGER_ATTRIBUTE);
    }

    public static void saveOutputFlashMap(String location, HttpServletRequest request2, HttpServletResponse response) {
        FlashMap flashMap = RequestContextUtils.getOutputFlashMap(request2);
        if (CollectionUtils.isEmpty(flashMap)) {
            return;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(location).build();
        flashMap.setTargetRequestPath(uriComponents.getPath());
        flashMap.addTargetRequestParams(uriComponents.getQueryParams());
        FlashMapManager manager = RequestContextUtils.getFlashMapManager(request2);
        Assert.state(manager != null, "No FlashMapManager. Is this a DispatcherServlet handled request?");
        manager.saveOutputFlashMap(flashMap, request2, response);
    }
}

