/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.MappingMatch;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public abstract class ServletRequestPathUtils {
    public static final String PATH_ATTRIBUTE = ServletRequestPathUtils.class.getName() + ".PATH";

    public static RequestPath parseAndCache(HttpServletRequest request2) {
        RequestPath requestPath = ServletRequestPath.parse(request2);
        request2.setAttribute(PATH_ATTRIBUTE, requestPath);
        return requestPath;
    }

    public static RequestPath getParsedRequestPath(ServletRequest request2) {
        RequestPath path = (RequestPath)request2.getAttribute(PATH_ATTRIBUTE);
        Assert.notNull((Object)path, () -> "Expected parsed RequestPath in request attribute \"" + PATH_ATTRIBUTE + "\".");
        return path;
    }

    public static void setParsedRequestPath(@Nullable RequestPath requestPath, ServletRequest request2) {
        if (requestPath != null) {
            request2.setAttribute(PATH_ATTRIBUTE, requestPath);
        } else {
            request2.removeAttribute(PATH_ATTRIBUTE);
        }
    }

    public static boolean hasParsedRequestPath(ServletRequest request2) {
        return request2.getAttribute(PATH_ATTRIBUTE) != null;
    }

    public static void clearParsedRequestPath(ServletRequest request2) {
        request2.removeAttribute(PATH_ATTRIBUTE);
    }

    public static Object getCachedPath(ServletRequest request2) {
        String lookupPath = (String)request2.getAttribute(UrlPathHelper.PATH_ATTRIBUTE);
        if (lookupPath != null) {
            return lookupPath;
        }
        RequestPath requestPath = (RequestPath)request2.getAttribute(PATH_ATTRIBUTE);
        if (requestPath != null) {
            return requestPath.pathWithinApplication();
        }
        throw new IllegalArgumentException("Neither a pre-parsed RequestPath nor a pre-resolved String lookupPath is available.");
    }

    public static String getCachedPathValue(ServletRequest request2) {
        Object path = ServletRequestPathUtils.getCachedPath(request2);
        if (path instanceof PathContainer) {
            PathContainer pathContainer = (PathContainer)path;
            String value = pathContainer.value();
            path = UrlPathHelper.defaultInstance.removeSemicolonContent(value);
        }
        return (String)path;
    }

    public static boolean hasCachedPath(ServletRequest request2) {
        return request2.getAttribute(PATH_ATTRIBUTE) != null || request2.getAttribute(UrlPathHelper.PATH_ATTRIBUTE) != null;
    }

    private static final class ServletRequestPath
    implements RequestPath {
        private final RequestPath requestPath;
        private final PathContainer contextPath;

        private ServletRequestPath(String rawPath, @Nullable String contextPath, String servletPathPrefix) {
            Assert.notNull((Object)servletPathPrefix, "`servletPathPrefix` is required");
            this.requestPath = RequestPath.parse(rawPath, contextPath + servletPathPrefix);
            this.contextPath = PathContainer.parsePath(StringUtils.hasText(contextPath) ? contextPath : "");
        }

        @Override
        public String value() {
            return this.requestPath.value();
        }

        @Override
        public List<PathContainer.Element> elements() {
            return this.requestPath.elements();
        }

        @Override
        public PathContainer contextPath() {
            return this.contextPath;
        }

        @Override
        public PathContainer pathWithinApplication() {
            return this.requestPath.pathWithinApplication();
        }

        @Override
        public RequestPath modifyContextPath(String contextPath) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.requestPath.equals(((ServletRequestPath)other).requestPath);
        }

        public int hashCode() {
            return this.requestPath.hashCode();
        }

        public String toString() {
            return this.requestPath.toString();
        }

        public static RequestPath parse(HttpServletRequest request2) {
            String requestUri = (String)request2.getAttribute("jakarta.servlet.include.request_uri");
            requestUri = requestUri != null ? requestUri : request2.getRequestURI();
            String servletPathPrefix = ServletRequestPath.getServletPathPrefix(request2);
            return StringUtils.hasText(servletPathPrefix) ? new ServletRequestPath(requestUri, request2.getContextPath(), servletPathPrefix) : RequestPath.parse(requestUri, request2.getContextPath());
        }

        @Nullable
        private static String getServletPathPrefix(HttpServletRequest request2) {
            HttpServletMapping mapping = (HttpServletMapping)request2.getAttribute("jakarta.servlet.include.mapping");
            HttpServletMapping httpServletMapping = mapping = mapping != null ? mapping : request2.getHttpServletMapping();
            if (ObjectUtils.nullSafeEquals((Object)mapping.getMappingMatch(), (Object)MappingMatch.PATH)) {
                String servletPath = (String)request2.getAttribute("jakarta.servlet.include.servlet_path");
                servletPath = servletPath != null ? servletPath : request2.getServletPath();
                servletPath = servletPath.endsWith("/") ? servletPath.substring(0, servletPath.length() - 1) : servletPath;
                return UriUtils.encodePath(servletPath, StandardCharsets.UTF_8);
            }
            return null;
        }
    }
}

