/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

public class FFT {
    protected float[] w1;
    protected float[] w2;
    protected float[] w3;

    public FFT(int logN) {
        this.w1 = new float[logN];
        this.w2 = new float[logN];
        this.w3 = new float[logN];
        int N = 1;
        int k = 0;
        while (k < logN) {
            double angle = Math.PI * -2 / (double)(N <<= 1);
            this.w1[k] = (float)Math.sin(0.5 * angle);
            this.w2[k] = -2.0f * this.w1[k] * this.w1[k];
            this.w3[k] = (float)Math.sin(angle);
            ++k;
        }
    }

    private void scramble(int n, float[] real, float[] imag) {
        int j = 0;
        int i2 = 0;
        while (i2 < n) {
            if (i2 > j) {
                float t = real[j];
                real[j] = real[i2];
                real[i2] = t;
                t = imag[j];
                imag[j] = imag[i2];
                imag[i2] = t;
            }
            int m = n >> 1;
            while (j >= m && m >= 2) {
                j -= m;
                m >>= 1;
            }
            j += m;
            ++i2;
        }
    }

    private void butterflies(int n, int logN, int direction, float[] real, float[] imag) {
        int N = 1;
        int k = 0;
        while (k < logN) {
            int half_N = N;
            N <<= 1;
            float wt = (float)direction * this.w1[k];
            float wp_re = this.w2[k];
            float wp_im = (float)direction * this.w3[k];
            float w_re = 1.0f;
            float w_im = 0.0f;
            int offset = 0;
            while (offset < half_N) {
                int i2 = offset;
                while (i2 < n) {
                    int j = i2 + half_N;
                    float re = real[j];
                    float im = imag[j];
                    float temp_re = w_re * re - w_im * im;
                    float temp_im = w_im * re + w_re * im;
                    real[j] = real[i2] - temp_re;
                    int n2 = i2;
                    real[n2] = real[n2] + temp_re;
                    imag[j] = imag[i2] - temp_im;
                    int n3 = i2;
                    imag[n3] = imag[n3] + temp_im;
                    i2 += N;
                }
                wt = w_re;
                w_re = wt * wp_re - w_im * wp_im + w_re;
                w_im = w_im * wp_re + wt * wp_im + w_im;
                ++offset;
            }
            ++k;
        }
        if (direction == -1) {
            float nr = 1.0f / (float)n;
            int i3 = 0;
            while (i3 < n) {
                int n4 = i3;
                real[n4] = real[n4] * nr;
                int n5 = i3++;
                imag[n5] = imag[n5] * nr;
            }
        }
    }

    public void transform1D(float[] real, float[] imag, int logN, int n, boolean forward) {
        this.scramble(n, real, imag);
        this.butterflies(n, logN, forward ? 1 : -1, real, imag);
    }

    public void transform2D(float[] real, float[] imag, int cols, int rows, boolean forward) {
        int log2cols = this.log2(cols);
        int log2rows = this.log2(rows);
        int n = Math.max(rows, cols);
        float[] rtemp = new float[n];
        float[] itemp = new float[n];
        int y = 0;
        while (y < rows) {
            int offset = y * cols;
            System.arraycopy(real, offset, rtemp, 0, cols);
            System.arraycopy(imag, offset, itemp, 0, cols);
            this.transform1D(rtemp, itemp, log2cols, cols, forward);
            System.arraycopy(rtemp, 0, real, offset, cols);
            System.arraycopy(itemp, 0, imag, offset, cols);
            ++y;
        }
        int x = 0;
        while (x < cols) {
            int index = x;
            int y2 = 0;
            while (y2 < rows) {
                rtemp[y2] = real[index];
                itemp[y2] = imag[index];
                index += cols;
                ++y2;
            }
            this.transform1D(rtemp, itemp, log2rows, rows, forward);
            index = x;
            y2 = 0;
            while (y2 < rows) {
                real[index] = rtemp[y2];
                imag[index] = itemp[y2];
                index += cols;
                ++y2;
            }
            ++x;
        }
    }

    private int log2(int n) {
        int m = 1;
        int log2n = 0;
        while (m < n) {
            m *= 2;
            ++log2n;
        }
        return m == n ? log2n : -1;
    }
}

