/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.dao;

import com.roma.romaapi.facade.MultipleDb;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DbApiDao {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    private MultipleDb multipleDb;

    public Map<String, Object> dbQueryForMap(String sqlCode) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sql_code", sqlCode);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT * FROM `sql_details` where sql_code = :sql_code AND is_enable=1", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public Integer dbCountQueryForObject(String datasource, String sql, Map bindValue) {
        NamedParameterJdbcTemplate execNamedParameterJdbcTemplate = this.multipleDb.getMultipleDatasourceByDbCode(datasource);
        Integer count = execNamedParameterJdbcTemplate.queryForObject(sql, bindValue, Integer.class);
        return count;
    }

    public Map dbCustomQueryForMap(String datasource, String sql, Map bindValue) {
        try {
            NamedParameterJdbcTemplate execNamedParameterJdbcTemplate = this.multipleDb.getMultipleDatasourceByDbCode(datasource);
            Map<String, Object> resMap2 = execNamedParameterJdbcTemplate.queryForMap(sql, bindValue);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public List<Map<String, Object>> dbCustomQueryForList(String datasource, String sql, Map<String, Object> bindValue) {
        NamedParameterJdbcTemplate execNamedParameterJdbcTemplate = this.multipleDb.getMultipleDatasourceByDbCode(datasource);
        List<Map<String, Object>> resMap2 = execNamedParameterJdbcTemplate.queryForList(sql, bindValue);
        return resMap2;
    }

    public Integer dbUpdate(String datasource, String sql, Map<String, Object> bindValue) {
        NamedParameterJdbcTemplate execNamedParameterJdbcTemplate = this.multipleDb.getMultipleDatasourceByDbCode(datasource);
        Integer row = execNamedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }
}

